/*
 * Decompiled with CFR 0.152.
 */
package com.tomaskovic.console;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;

public class TerminalWindow {
    PrintStream stdout;
    InputStream stdin;
    public String sType = "console";

    public TerminalWindow(PrintStream stdout, InputStream stdin) {
        this.stdout = stdout;
        this.stdin = stdin;
    }

    public int getWidth() throws Exception {
        this.stdout.println("Querying window width...");
        this.clearScreen();
        this.stdout.print("Done.");
        return 0;
    }

    public void clearScreen() {
        this.sendESC("[2J");
    }

    public void setCursorPosition(int x, int y) {
        this.sendESC("[H");
    }

    public CursorPosition getCursorPosition() throws Exception {
        System.out.println("Query...");
        this.sendESC("[6n");
        System.out.println("Read...");
        String s = this.readUntil('R');
        if (s.length() < 1 || s.charAt(0) != '\u001b') {
            throw new Exception("Escape character expected on position 0");
        }
        if (s.length() < 1 || s.charAt(1) != '[') {
            throw new Exception("'[' character expected on position 1");
        }
        int iDivider = s.indexOf(";");
        if (iDivider == -1) {
            throw new Exception("';' character expected in response");
        }
        String sX = s.substring(2, iDivider);
        String sY = s.substring(iDivider, s.length());
        CursorPosition pos = new CursorPosition(this);
        pos.x = Integer.parseInt(sX);
        pos.y = Integer.parseInt(sY);
        return pos;
    }

    public void sendESC(String sSequence) {
        this.stdout.print(String.valueOf(String.valueOf('\u001b')).concat(String.valueOf(String.valueOf(sSequence))));
    }

    public String readUntil(char c) throws IOException {
        String s = "";
        while (true) {
            System.out.println("Available: ".concat(String.valueOf(String.valueOf(this.stdin.available()))));
            byte[] ba = new byte[1];
            System.in.read(ba, 0, 1);
            char cc = (char)ba[0];
            System.out.println("Read: ".concat(String.valueOf(String.valueOf(cc))));
            if (cc == c) {
                return s;
            }
            s = String.valueOf(String.valueOf(s)).concat(String.valueOf(String.valueOf(c)));
        }
    }

    public void print(String sLine) {
        this.stdout.print(sLine);
    }

    public void println(String sLine) {
        if (this.sType.equalsIgnoreCase("VT100")) {
            this.stdout.print(sLine);
            this.sendESC(String.valueOf(String.valueOf(new StringBuffer("[").append(sLine.length()).append("D"))));
            this.sendESC("[D");
            this.sendESC("[1B");
        } else {
            this.stdout.println(sLine);
        }
    }

    public void goToStartOfLine() {
        this.stdout.print("\r");
    }

    public void goCursorUp(int iRows) {
        if (this.sType.equalsIgnoreCase("VT100")) {
            this.sendESC(String.valueOf(String.valueOf(new StringBuffer("[").append(iRows).append("A"))));
        }
    }

    public class CursorPosition {
        public int x;
        public int y;

        public CursorPosition(TerminalWindow this$0) {
        }
    }
}

