/*
 * Decompiled with CFR 0.152.
 */
package com.tomaskovic.tjadconsole;

import com.tomaskovic.console.MaskingThread;
import com.tomaskovic.console.TerminalWindow;
import com.tomaskovic.tjadconsole.Config;
import com.tomaskovic.util.DBAdapter;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;

public class AppConsole {
    Config config;
    Connection conn;
    Statement statement;
    Vector vHistory = new Vector();
    TerminalWindow w;
    int iLeft = 0;
    int[] iColumnDisplaySize = null;

    public AppConsole() {
        this.config = new Config("TJADConsole.prop");
        this.w = new TerminalWindow(System.out, System.in);
    }

    public int run() {
        this.println("------====== TJADConsole v31-10-2002, by Matija Tomaskovic ======------");
        try {
            this.println("Loading configuration from: ".concat(String.valueOf(String.valueOf(this.config.sConfigPathFilename))));
            this.config.load();
        }
        catch (FileNotFoundException fnfe) {
            this.println("Configuration file not found");
        }
        catch (IOException ex) {
            this.println("Error reading config file: ".concat(String.valueOf(String.valueOf(this.config.sConfigPathFilename))));
            this.println("Exiting application...");
            int n = 1;
            return n;
        }
        String s = this.getValue("Connect (yes/no)?", "yes");
        if (s.equalsIgnoreCase("yes")) {
            this.handleConnect();
        }
        this.println("Hello! Type 'help' for help; SQL commands must end with ';'");
        this.config.save();
        String sCommand = "";
        while (true) {
            String sPrompt = this.conn != null ? this.config.sDBUser : "SQL";
            String sLine = sCommand.length() == 0 ? this.getValue(String.valueOf(String.valueOf(sPrompt)).concat(">")) : this.getValue(this.lpad(">", sPrompt.length() + 1, '.'));
            if (sLine.trim().length() == 0) {
                sCommand = "";
                continue;
            }
            if (sLine.equalsIgnoreCase("quit") || sLine.equalsIgnoreCase("q") || sLine.equalsIgnoreCase("exit") || sLine.equalsIgnoreCase("bye")) break;
            if (sLine.equalsIgnoreCase("help") || sLine.equalsIgnoreCase("?")) {
                this.showHelp();
                sCommand = "";
                continue;
            }
            if (sLine.equalsIgnoreCase("config") || sLine.equalsIgnoreCase("info")) {
                this.editConfig();
                sCommand = "";
                continue;
            }
            if (sLine.equalsIgnoreCase("disconnect") || sLine.equalsIgnoreCase("d")) {
                this.closeConnection();
                sCommand = "";
                continue;
            }
            if (sLine.equalsIgnoreCase("connect") || sLine.equalsIgnoreCase("c")) {
                this.handleConnect();
                sCommand = "";
                continue;
            }
            if (sLine.equalsIgnoreCase("history") || sLine.equalsIgnoreCase("h")) {
                this.handleHistory();
                sCommand = "";
                continue;
            }
            if (sLine.equalsIgnoreCase("ruler")) {
                this.handleRuler();
                sCommand = "";
                continue;
            }
            sCommand = sCommand.length() == 0 ? sLine : String.valueOf(String.valueOf(sCommand)).concat(String.valueOf(String.valueOf("\n".concat(String.valueOf(String.valueOf(sLine))))));
            if (!sLine.endsWith(";")) continue;
            this.execCommand(sCommand);
            sCommand = "";
        }
        return this.saveConfigAndExit();
    }

    private void showHelp() {
        this.println("+------------------- TJADConsole help -----------------------+");
        this.println("|command          shortcut description                       |");
        this.println("+---------------- -------- ----------------------------------+");
        this.println("|connect             c     connect to database               |");
        this.println("|disconnect          d     disconnect from database          |");
        this.println("|history             h     show history                      |");
        this.println("|ruler                     display ruler to edit screen size |");
        this.println("|config/info               show and edit configuration       |");
        this.println("|quit/exit/bye       q     exits application                 |");
        this.println("|help                ?     this help screen                  |");
        this.println("|[anything else]           SQL statement                     |");
        this.println("+------------------------------------------------------------+");
        this.println("|SQL commands must end with ';'                              |");
        this.println("|In most of menus you can use first letter of commands.      |");
        this.println("+------------------------------------------------------------+");
    }

    public int saveConfigAndExit() {
        this.closeConnection();
        System.out.println("Bye.");
        this.config.save();
        return 1;
    }

    public String getValue(String sQuestion) {
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        System.out.print(sQuestion);
        System.out.flush();
        try {
            String sValue = in.readLine();
            if (sValue.trim().length() == 0) {
                String string = "";
                return string;
            }
            String string = sValue;
            return string;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            String string = "";
            return string;
        }
    }

    public String getPasswordValue(String sQuestion) {
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        System.out.print(sQuestion);
        System.out.flush();
        MaskingThread t = new MaskingThread(sQuestion);
        t.start();
        String sValue = "";
        try {
            String s = in.readLine();
            t.stopMasking();
            try {
                Thread.sleep(30L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            sValue = s.trim().length() == 0 ? "" : s;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            t.stopMasking();
            sValue = "";
        }
        return sValue;
    }

    public String getValue(String sQuestion, String sDefaultValue) {
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        System.out.print(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(sQuestion))).append(" (").append(sDefaultValue).append("): "))));
        System.out.flush();
        try {
            String sValue = in.readLine();
            if (sValue.trim().length() == 0) {
                String string = sDefaultValue;
                return string;
            }
            String string = sValue;
            return string;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            String string = sDefaultValue;
            return string;
        }
    }

    public void print(String sLine) {
        this.w.print(sLine);
    }

    public void println(String sLine) {
        this.w.println(sLine);
    }

    private void execCommand(String sSQL) {
        this.vHistory.insertElementAt(sSQL, 0);
        sSQL = sSQL.trim();
        if (sSQL.endsWith(";")) {
            sSQL = sSQL.substring(0, sSQL.length() - 1);
        }
        if (sSQL.length() >= "select".length() && sSQL.substring(0, "select".length()).toLowerCase().equals("select")) {
            this.executeSelectSQL(sSQL);
            return;
        }
        this.executeUpdateSQL(sSQL);
    }

    private void executeSelectSQL(String strSQL) {
        if (strSQL.equals("")) {
            this.showSQLException("No SQL command", null);
            return;
        }
        if (this.statement == null) {
            this.showSQLException("No opened connection.", null);
            return;
        }
        try {
            ResultSet resultset = this.statement.executeQuery(strSQL);
            ResultSetMetaData rsMetaData = resultset.getMetaData();
            String str = "";
            int iColumnCount = rsMetaData.getColumnCount();
            this.iColumnDisplaySize = null;
            int iRowCount = 0;
            this.iLeft = 0;
            this.iColumnDisplaySize = null;
            Vector vRowsOfPage = new Vector();
            while (resultset.next()) {
                ++iRowCount;
                Vector<String> vRow = new Vector<String>();
                for (int i = 1; i < iColumnCount + 1; ++i) {
                    vRow.add(resultset.getString(i));
                }
                vRowsOfPage.add(vRow);
                if (iRowCount % this.config.iRowsPerPage != 0) continue;
                if (!this.showResultSet(rsMetaData, vRowsOfPage, iRowCount, false)) {
                    return;
                }
                vRowsOfPage = new Vector();
            }
            if (vRowsOfPage.size() > 0) {
                this.showResultSet(rsMetaData, vRowsOfPage, iRowCount, true);
            }
            this.println(String.valueOf(String.valueOf(iRowCount)).concat(" total rows..."));
        }
        catch (SQLException ee) {
            this.showSQLException(strSQL, ee);
        }
    }

    private boolean showResultSet(ResultSetMetaData rsMetaData, Vector vRowsOfPage, int iRowCount, boolean bLastPage) throws SQLException {
        int iStep = this.config.iScrollColumnStep;
        int iWidth = this.config.iPageWidth - 8;
        if (iStep > iWidth - 10) {
            iStep = iWidth - 10;
        }
        int iColumnCount = rsMetaData.getColumnCount();
        int iRows = vRowsOfPage.size();
        block0: while (true) {
            if (this.iColumnDisplaySize == null) {
                this.calcColumnDisplaySize(rsMetaData, vRowsOfPage);
            }
            String sHeader = "";
            String sHeaderLine = "";
            for (int i = 0; i < iColumnCount; ++i) {
                String s = rsMetaData.getColumnLabel(i + 1);
                if (s.length() > this.iColumnDisplaySize[i]) {
                    s = s.substring(0, this.iColumnDisplaySize[i]);
                }
                sHeader = String.valueOf(String.valueOf(sHeader)).concat(String.valueOf(String.valueOf(this.rpad(s, this.iColumnDisplaySize[i]))));
                sHeaderLine = String.valueOf(String.valueOf(sHeaderLine)).concat(String.valueOf(String.valueOf(this.rpad("", this.iColumnDisplaySize[i], '-'))));
                if (i >= iColumnCount) continue;
                sHeader = String.valueOf(String.valueOf(sHeader)).concat(" ");
                sHeaderLine = String.valueOf(String.valueOf(sHeaderLine)).concat(" ");
            }
            String strFullHeaderLine = this.rpad("", sHeader.length(), '-');
            Vector<String> vStringRows = new Vector<String>();
            for (int iRow = 0; iRow < iRows; ++iRow) {
                String strRow = "";
                for (int i = 0; i < iColumnCount; ++i) {
                    Vector vRow = (Vector)vRowsOfPage.elementAt(iRow);
                    String s = (String)vRow.elementAt(i);
                    if (s == null) {
                        s = "";
                    }
                    if (s.length() > this.iColumnDisplaySize[i]) {
                        s = s.substring(0, this.iColumnDisplaySize[i]);
                    }
                    strRow = String.valueOf(String.valueOf(strRow)).concat(String.valueOf(String.valueOf(this.rpad(s, this.iColumnDisplaySize[i]))));
                    if (i >= iColumnCount) continue;
                    strRow = String.valueOf(String.valueOf(strRow)).concat(" ");
                }
                vStringRows.add(strRow);
            }
            while (true) {
                this.println(String.valueOf(String.valueOf(new StringBuffer("     [").append(this.rpad("Col: ".concat(String.valueOf(String.valueOf(this.iLeft))), iWidth - 20, '-')).append(this.lpad(String.valueOf(String.valueOf(new StringBuffer("Col: ").append(this.iLeft + iWidth).append(" of ").append(sHeader.length()))), 20, '-')).append("]"))));
                this.print("     |");
                if (this.iLeft + iWidth >= sHeader.length()) {
                    this.println(String.valueOf(String.valueOf(sHeader.substring(this.iLeft))).concat("|"));
                } else {
                    this.println(String.valueOf(String.valueOf(sHeader.substring(this.iLeft, this.iLeft + iWidth))).concat("|"));
                }
                this.print("-row-+");
                if (this.iLeft + iWidth >= sHeaderLine.length()) {
                    this.println(String.valueOf(String.valueOf(sHeaderLine.substring(this.iLeft))).concat("|"));
                } else {
                    this.println(String.valueOf(String.valueOf(sHeaderLine.substring(this.iLeft, this.iLeft + iWidth))).concat("|"));
                }
                for (int i = 0; i < iRows; ++i) {
                    String s = this.lpad(String.valueOf(String.valueOf(new StringBuffer("").append(iRowCount - iRows + i + 1))), 5, ' ');
                    this.print(String.valueOf(String.valueOf(s)).concat("|"));
                    String sLine = (String)vStringRows.elementAt(i);
                    if (this.iLeft + iWidth >= sLine.length()) {
                        this.println(String.valueOf(String.valueOf(sLine.substring(this.iLeft))).concat("|"));
                        continue;
                    }
                    this.println(String.valueOf(String.valueOf(sLine.substring(this.iLeft, this.iLeft + iWidth))).concat("|"));
                }
                this.println(String.valueOf(String.valueOf(new StringBuffer("-----[").append(this.rpad("Col: ".concat(String.valueOf(String.valueOf(this.iLeft))), iWidth - 20, '.')).append(this.lpad(String.valueOf(String.valueOf(new StringBuffer("Col: ").append(this.iLeft + iWidth).append(" of ").append(sHeader.length()))), 20, '.')).append("]"))));
                String s = bLastPage && sHeader.length() <= iWidth ? this.getValue("Size (f/n/d/m/q/?)", "quit") : (bLastPage ? this.getValue("Navigate/size (l/r/h/e/f/n/d/m/q/?)", "quit") : this.getValue("Continue/navigate/size (continue/q/l/r/h/e/f/n/d/m/q/?)", "continue"));
                if (s.equalsIgnoreCase("continue")) {
                    return true;
                }
                if (s.equalsIgnoreCase("L") || s.equalsIgnoreCase("left")) {
                    if (this.iLeft >= iStep) {
                        this.iLeft -= iStep;
                    }
                    this.w.goToStartOfLine();
                    this.w.goCursorUp(iRows + 4);
                    continue;
                }
                if (s.equalsIgnoreCase("R") || s.equalsIgnoreCase("right")) {
                    if (this.iLeft + iStep < sHeader.length()) {
                        this.iLeft += iStep;
                    }
                    this.w.goToStartOfLine();
                    this.w.goCursorUp(iRows + 4);
                    continue;
                }
                if (s.equalsIgnoreCase("h") || s.equalsIgnoreCase("home")) {
                    this.iLeft = 0;
                    continue;
                }
                if (s.equalsIgnoreCase("e") || s.equalsIgnoreCase("end")) {
                    this.iLeft = sHeader.length() - iWidth;
                    continue;
                }
                if (s.equalsIgnoreCase("f") || s.equalsIgnoreCase("fit")) {
                    this.iLeft = 0;
                    this.config.sColumnSize = "fit";
                    this.iColumnDisplaySize = null;
                    continue block0;
                }
                if (s.equalsIgnoreCase("m") || s.equalsIgnoreCase("max")) {
                    this.iLeft = 0;
                    this.config.sColumnSize = "max";
                    this.iColumnDisplaySize = null;
                    continue block0;
                }
                if (s.equalsIgnoreCase("d") || s.equalsIgnoreCase("data")) {
                    this.iLeft = 0;
                    this.config.sColumnSize = "data";
                    this.iColumnDisplaySize = null;
                    continue block0;
                }
                if (s.equalsIgnoreCase("n") || s.equalsIgnoreCase("name")) {
                    this.iLeft = 0;
                    this.config.sColumnSize = "label";
                    this.iColumnDisplaySize = null;
                    continue block0;
                }
                if (!s.equalsIgnoreCase("h") && !s.equalsIgnoreCase("?") && !s.equalsIgnoreCase("help")) break block0;
                this.println("+---------------------------------------------------+");
                this.println("|Resultset navigation:                              |");
                this.println("|l or left           - scroll left                  |");
                this.println("|r or right          - scroll right                 |");
                this.println("|h or home           - scroll to home (left)        |");
                this.println("|e or end            - scroll to end (right)        |");
                this.println("|f or fit            - set 'fit' column size        |");
                this.println("|m or max            - set 'max' column size        |");
                this.println("|d or data           - set 'data' column size       |");
                this.println("|n or name           - set 'label' name column size |");
                this.println("|continue or 'enter' - continue (next page)         |");
                this.println("|q or quit           - stop browsing                |");
                this.println("|? or help           - show this help               |");
                this.println("+---------------------------------------------------+");
                this.getValue("Press enter to continue");
            }
            break;
        }
        return false;
    }

    private void calcColumnDisplaySize(ResultSetMetaData rsMetaData, Vector vRowsOfPage) throws SQLException {
        int iColumnCount = rsMetaData.getColumnCount();
        int iRows = vRowsOfPage.size();
        this.iColumnDisplaySize = new int[iColumnCount];
        for (int iCol = 0; iCol < iColumnCount; ++iCol) {
            int iLabelSize = rsMetaData.getColumnLabel(iCol + 1).trim().length();
            int iValueSize = rsMetaData.getColumnDisplaySize(iCol + 1);
            int iMaxDataSize = 1;
            int iMinDataSize = 1;
            for (int t = 0; t < iRows; ++t) {
                Vector vRow = (Vector)vRowsOfPage.elementAt(t);
                String sValue = (String)vRow.elementAt(iCol);
                int iSize = 0;
                iSize = sValue == null ? 0 : sValue.length();
                if (t == 0 || iSize < iMinDataSize) {
                    iMinDataSize = iSize;
                }
                if ((t != 0 || iSize <= 0) && iSize <= iMaxDataSize) continue;
                iMaxDataSize = iSize;
            }
            if (this.config.sColumnSize.equalsIgnoreCase("fit")) {
                if (iMaxDataSize > iLabelSize) {
                    this.iColumnDisplaySize[iCol] = iMaxDataSize;
                    continue;
                }
                this.iColumnDisplaySize[iCol] = iLabelSize;
                continue;
            }
            this.iColumnDisplaySize[iCol] = this.config.sColumnSize.equalsIgnoreCase("label") ? iLabelSize : (this.config.sColumnSize.equalsIgnoreCase("data") ? iMaxDataSize : (this.config.sColumnSize.equalsIgnoreCase("max") ? iValueSize : iLabelSize));
        }
    }

    private void showSQLException(String sText, Exception ex) {
        if (ex == null) {
            this.println(sText);
        } else {
            this.println(sText);
            this.println(ex.getMessage());
        }
    }

    private void executeUpdateSQL(String strSQL) {
        if ((strSQL = strSQL.trim()).equals("")) {
            this.showSQLException("No SQL update command", null);
            return;
        }
        if (this.statement == null) {
            this.showSQLException("No opened connection.", null);
            return;
        }
        try {
            int iResult = this.statement.executeUpdate(strSQL);
            this.println(String.valueOf(String.valueOf(iResult)).concat(" rows affected..."));
        }
        catch (SQLException ee) {
            this.showSQLException(strSQL, ee);
        }
    }

    public String rpad(String str, int iLen) {
        return this.rpad(str, iLen, ' ');
    }

    public String rpad(String str, int iLen, char c) {
        if (str == null) {
            str = "";
        }
        if (str.length() >= iLen) {
            str = str.substring(0, iLen);
            return str;
        }
        while (str.length() < iLen) {
            str = String.valueOf(String.valueOf(str)).concat(String.valueOf(String.valueOf(c)));
        }
        return str;
    }

    public String lpad(String s, int iLen, char c) {
        while (s.length() < iLen) {
            s = String.valueOf(String.valueOf(c)).concat(String.valueOf(String.valueOf(s)));
        }
        return s;
    }

    private void editConfig() {
        while (true) {
            this.println(" [1] Page width:           ".concat(String.valueOf(String.valueOf(this.config.iPageWidth))));
            this.println(" [2] Rows per page:        ".concat(String.valueOf(String.valueOf(this.config.iRowsPerPage))));
            this.println(" [3] Screen height:        ".concat(String.valueOf(String.valueOf(this.config.iScreenHeight))));
            this.println(" [4] Scroll column step:   ".concat(String.valueOf(String.valueOf(this.config.iScrollColumnStep))));
            this.println(" [5] JDBC driver:          ".concat(String.valueOf(String.valueOf(this.config.sJdbcDriver))));
            this.println(" [6] JDBC URL:             ".concat(String.valueOf(String.valueOf(this.config.sJdbcURL))));
            this.println(" [7] Autocommit:           ".concat(String.valueOf(String.valueOf(this.config.bAutoCommit))));
            this.println(" [8] Column size:          ".concat(String.valueOf(String.valueOf(this.config.sColumnSize))));
            this.println(" [9] Mask password:        ".concat(String.valueOf(String.valueOf(this.config.bMaskPassword))));
            this.println(" [q] to exit configuration");
            String sCommand = this.getValue("Your choice: ");
            if (sCommand.trim().length() == 0) {
                return;
            }
            try {
                String s;
                int i;
                String sValue;
                if (sCommand.equals("1")) {
                    sValue = this.getValue("Page width", "".concat(String.valueOf(String.valueOf(this.config.iPageWidth))));
                    this.config.iPageWidth = i = Integer.parseInt(sValue);
                } else if (sCommand.startsWith("2")) {
                    sValue = this.getValue("Rows per page", "".concat(String.valueOf(String.valueOf(this.config.iRowsPerPage))));
                    this.config.iRowsPerPage = i = Integer.parseInt(sValue);
                } else if (sCommand.startsWith("3")) {
                    sValue = this.getValue("Screen height", "".concat(String.valueOf(String.valueOf(this.config.iScreenHeight))));
                    this.config.iScreenHeight = i = Integer.parseInt(sValue);
                } else if (sCommand.startsWith("4")) {
                    sValue = this.getValue("Scroll column step", "".concat(String.valueOf(String.valueOf(this.config.iScrollColumnStep))));
                    this.config.iScrollColumnStep = i = Integer.parseInt(sValue);
                } else if (sCommand.startsWith("5")) {
                    s = this.getValue("JDBC driver");
                    if (s.trim().length() > 0) {
                        this.config.sJdbcDriver = s;
                    }
                } else if (sCommand.startsWith("6")) {
                    s = this.getValue("JDBC URL");
                    if (s.trim().length() > 0) {
                        this.config.sJdbcURL = s;
                    }
                } else if (sCommand.startsWith("7")) {
                    s = this.getValue("Autocommit (true/false)", "".concat(String.valueOf(String.valueOf(this.config.bAutoCommit))));
                    this.config.bAutoCommit = s.equalsIgnoreCase("true");
                } else if (sCommand.startsWith("8")) {
                    this.config.sColumnSize = this.getValue("Column size (fit/label/data/max)", this.config.sColumnSize);
                } else if (sCommand.startsWith("9")) {
                    s = this.getValue("Mask password (true/false)", "".concat(String.valueOf(String.valueOf(this.config.bMaskPassword))));
                    this.config.bMaskPassword = s.equalsIgnoreCase("true");
                } else {
                    return;
                }
                this.println("Ok.");
                this.config.save();
                continue;
            }
            catch (Exception ex) {
                this.println("Failed to set parameter: ".concat(String.valueOf(String.valueOf(ex.getMessage()))));
                continue;
            }
            break;
        }
    }

    private void handleConnect() {
        this.closeConnection();
        this.config.sDBUser = this.getValue("DB user", this.config.sDBUser);
        this.config.sDBPassword = this.config.bMaskPassword ? this.getPasswordValue("DB password: ") : this.getValue("DB password: ");
        if (!DBAdapter.registerJdbcDriver(this.config.sJdbcDriver)) {
            return;
        }
        this.conn = DBAdapter.connectToDatabase(this.config.sJdbcURL, this.config.sDBUser, this.config.sDBPassword);
        if (this.conn == null) {
            return;
        }
        this.println("Connected...");
        try {
            this.conn.setAutoCommit(this.config.bAutoCommit);
        }
        catch (SQLException ex) {
            this.println(String.valueOf(String.valueOf(new StringBuffer("Failed to set autocommit to ").append(this.config.bAutoCommit).append(": ").append(ex.getMessage()))));
        }
        try {
            this.statement = this.conn.createStatement();
        }
        catch (SQLException ex) {
            this.println("Failed to create statement");
            return;
        }
        this.config.save();
    }

    private void closeConnection() {
        if (this.statement != null) {
            try {
                this.statement.close();
                this.statement = null;
            }
            catch (SQLException ex) {
                this.println("Error closing statement: ".concat(String.valueOf(String.valueOf(ex.getMessage()))));
            }
        }
        if (this.conn != null) {
            try {
                this.conn.close();
                this.conn = null;
            }
            catch (SQLException ex) {
                this.println("Error closing connection: ".concat(String.valueOf(String.valueOf(ex.getMessage()))));
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void handleHistory() {
        iCount = this.vHistory.size();
        if (iCount == 0) {
            this.println("No history.");
            return;
        }
        iLines = 0;
        iRow = 0;
        do lbl-1000:
        // 3 sources

        {
            block12: {
                if ((sLine = (String)this.vHistory.elementAt(++iRow - 1)).indexOf("\n") == -1) {
                    this.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.lpad(String.valueOf(String.valueOf(new StringBuffer("(").append(iRow).append(")"))), 5, ' ')))).append(" => ").append(sLine))));
                    ++iLines;
                } else {
                    i = 0;
                    while (true) {
                        if (i == 0) {
                            this.print(String.valueOf(String.valueOf(this.lpad(String.valueOf(String.valueOf(new StringBuffer("(").append(iRow).append(")"))), 5, ' '))).concat(" => "));
                        } else {
                            this.print("         ");
                        }
                        t = sLine.indexOf("\n");
                        s = t == -1 ? sLine : sLine.substring(0, t);
                        this.println(s);
                        sLine = sLine.substring(t + 1);
                        if (t == -1) break;
                        ++i;
                        ++iLines;
                    }
                }
                if (iLines < this.config.iScreenHeight - 5 && iRow != this.vHistory.size()) continue;
                iLines = 0;
                s = iRow == this.vHistory.size() ? this.getValue("Your choice (number/quit)?") : this.getValue("Your choice (number/continue/quit)?", "continue");
                if (!s.equalsIgnoreCase("continue") && !s.startsWith("c")) break block12;
                if (iRow != this.vHistory.size()) ** GOTO lbl-1000
                return;
            }
            if (s.equalsIgnoreCase("quit") || s.startsWith("q")) {
                return;
            }
            try {
                iNumber = Integer.parseInt(s);
                if (iNumber < 1 || iNumber > this.vHistory.size()) {
                    this.println("Bad choice");
                    return;
                }
                this.println(this.rpad("", this.config.iPageWidth - 1, '-'));
                sSQL = (String)this.vHistory.elementAt(iNumber - 1);
                this.println(sSQL);
                s = this.getValue("Execute (yes/no)?", "yes");
                if (s.equalsIgnoreCase("yes")) {
                    this.execCommand(sSQL);
                }
            }
            catch (Exception ex) {
                this.println("Unknown number: ".concat(String.valueOf(String.valueOf(ex.getMessage()))));
            }
            return;
        } while (iRow != this.vHistory.size());
    }

    private void handleRuler() {
        String ss;
        this.println("Press enter until you measure your screen width, then type 'q' and press enter");
        int w = 10;
        while (true) {
            for (int i = 10; i <= w; i += 10) {
                this.print("....5".concat(String.valueOf(String.valueOf(this.lpad("".concat(String.valueOf(String.valueOf(i))), 5, '.')))));
            }
            ss = this.getValue("");
            if (ss.length() != 0) break;
            w += 10;
        }
        ss = this.getValue("Columns? ");
        try {
            this.config.iPageWidth = Integer.parseInt(ss);
        }
        catch (Exception ex) {
            this.println("You typed bad value: ".concat(String.valueOf(String.valueOf(ex.getMessage()))));
        }
        this.getValue("Now click enter to see your screen height.");
        for (int i = 200; i > 1; --i) {
            this.println("".concat(String.valueOf(String.valueOf(i))));
        }
        ss = this.getValue("Rows? ");
        try {
            this.config.iScreenHeight = Integer.parseInt(ss);
        }
        catch (Exception ex) {
            this.println("You typed bad value: ".concat(String.valueOf(String.valueOf(ex.getMessage()))));
        }
    }

    public static void main(String[] args) {
        AppConsole app = new AppConsole();
        try {
            app.run();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

