/*
 * Decompiled with CFR 0.152.
 */
package com.tomaskovic.tjadconsole;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;

public class Config {
    String sConfigPathFilename;
    Properties props = new Properties();
    String sJdbcDriver = "oracle.jdbc.driver.OracleDriver";
    String sJdbcURL = "jdbc:oracle:thin:@localhost:1521:orcl";
    String sDBUser = "scott";
    String sDBPassword = "tiger";
    boolean bAutoCommit = false;
    int iRowsPerPage = 20;
    int iScreenHeight = 25;
    int iPageWidth = 79;
    int iScrollColumnStep = 50;
    boolean bMaskPassword = true;
    String sTerminal = "console";
    String sColumnSize = "fit";

    public Config(String sConfigFilename) {
        this.sConfigPathFilename = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(System.getProperty("user.dir")))).append(File.separator).append(sConfigFilename)));
    }

    public void save() {
        ((Hashtable)this.props).put("jdbc_driver", this.sJdbcDriver);
        ((Hashtable)this.props).put("jdbc_url", this.sJdbcURL);
        ((Hashtable)this.props).put("db_user", this.sDBUser);
        ((Hashtable)this.props).put("autocommit", "".concat(String.valueOf(String.valueOf(this.bAutoCommit))));
        ((Hashtable)this.props).put("rows_per_page", "".concat(String.valueOf(String.valueOf(this.iRowsPerPage))));
        ((Hashtable)this.props).put("page_width", "".concat(String.valueOf(String.valueOf(this.iPageWidth))));
        ((Hashtable)this.props).put("screen_height", "".concat(String.valueOf(String.valueOf(this.iScreenHeight))));
        ((Hashtable)this.props).put("column_size", this.sColumnSize);
        ((Hashtable)this.props).put("scroll_column_step", "".concat(String.valueOf(String.valueOf(this.iScrollColumnStep))));
        ((Hashtable)this.props).put("mask_password", "".concat(String.valueOf(String.valueOf(this.bMaskPassword))));
        ((Hashtable)this.props).put("terminal", this.sTerminal);
        try {
            this.props.store(new FileOutputStream(this.sConfigPathFilename), "TJADConsole config file");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void load() throws IOException, FileNotFoundException {
        this.props.load(new FileInputStream(this.sConfigPathFilename));
        this.sJdbcDriver = this.getString("jdbc_driver", this.sJdbcDriver);
        this.sJdbcURL = this.getString("jdbc_url", this.sJdbcURL);
        this.sDBUser = this.getString("db_user", this.sDBUser);
        this.bAutoCommit = this.getBoolean("autocommit", this.bAutoCommit);
        this.iRowsPerPage = this.getInt("rows_per_page", this.iRowsPerPage);
        this.iPageWidth = this.getInt("page_width", this.iPageWidth);
        this.iScreenHeight = this.getInt("screen_height", this.iScreenHeight);
        this.iScrollColumnStep = this.getInt("scroll_column_step", this.iScrollColumnStep);
        this.sColumnSize = this.getString("column_size", this.sColumnSize);
        this.bMaskPassword = this.getBoolean("mask_password", this.bMaskPassword);
        this.sTerminal = this.getString("column_size", this.sTerminal);
    }

    private String getString(String sName, String sDefault) {
        String sValue = (String)((Hashtable)this.props).get(sName);
        if (sValue == null) {
            return sDefault;
        }
        return sValue;
    }

    private boolean getBoolean(String sName, boolean bDefault) {
        String sValue = (String)((Hashtable)this.props).get(sName);
        if (sValue == null) {
            return bDefault;
        }
        return sValue.equalsIgnoreCase("true");
    }

    private int getInt(String sName, int iDefault) {
        String sValue = (String)((Hashtable)this.props).get(sName);
        if (sValue == null) {
            return iDefault;
        }
        try {
            int n = Integer.parseInt(sValue);
            return n;
        }
        catch (Exception ex) {
            int n = iDefault;
            return n;
        }
    }
}

