/**
 * ActionToggle.java
 * v1.0
 * 
 * by Matija Tomaskovic
 * (mataya@unforgettable.com || http://www.foi.hr/~mtomasko)
 * 
 * Use this object for toggle action. It spends given time and
 * takes care to toggle its flag (m_bFlag).
 * 
 *** Usage ***
 * 
 * 1. Create this object:
 * 
 *		ActionToggle a = new ActionToggle(1000);	// initial toggle period is 1000ms
 * 
 * 2. Change toggle period whenever you want:
 * 
 *		a.m_lTogglePeriod = 500;	// in milliseconds
 * 
 * 3. When you have some time to process, do like this:
 * 
 *		a.doAction(lTimeForAction);
 *		if (a.m_bChanged)
 *			.. do when changed ..
 * 
 *	or like this:
 * 
 *		a.doAction(lTimeForAction);
 *		if ((a.m_bChanged) && (a.m_bFlag))
 *			.. do on ..
 *		else if ((a.m_bChanged) && (!a.m_bFlag))
 *			.. do off ..
 * 
 *** LOG ***
 * 30.Dec.1999.
 * ~~~~~~~~~~~~
 *	14:44..	- created
 *	..14:52	- finalized version 1.0
 */

public class ActionToggle
{
	
	public long m_lTogglePeriod;	// in milliseconds
	
	public boolean m_bFlag = true;
	public boolean m_bChanged = true;	// indicates that flag has changed in last doAction(..)
	
	private long m_lToggleTime;		// cumulative of time (raises up to m_lTogglePeriod when toggle is done)
	
	/** CONSTRUCTION *******************************************************/
	
	public ActionToggle(long lTogglePeriod)
	{
		m_lTogglePeriod = lTogglePeriod;
	}

	/** ACTION HANDLER *****************************************************/

	/**
	 * Spends given time on action, and updates m_bFlag & m_bChanged
	 */
	public void doAction(long lTimeForAction)
	{
		m_bChanged = false;
		m_lToggleTime += lTimeForAction;
		lTimeForAction = 0;
			
		while (m_lToggleTime >= m_lTogglePeriod)
		{
			m_lToggleTime -= m_lTogglePeriod;
			m_bFlag = !m_bFlag;
			m_bChanged = true;
		}
	}

	/**
	 * Resets internal counter (starts counting from 0)
	 * Sets m_bChanged to false
	 * Sets m_bFlag to true
	 */
	public void reset()
	{
		m_lToggleTime = 0;
		m_bChanged = false;
		m_bFlag = true;
	}
}

