// TerrainMap.h: interface for the TerrainMap class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_TERRAINMAP_H__45DD064E_80D5_11D5_B3C1_0050DA2CE9D2__INCLUDED_)
#define AFX_TERRAINMAP_H__45DD064E_80D5_11D5_B3C1_0050DA2CE9D2__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include <tomaskovic\engine3d\GLTextureManager.h>
#include <tomaskovic\engine3d\Vector3f.h>

class TerrainMap {
public:
	TerrainMap();
	virtual ~TerrainMap();

	void Create(int iWidth, int iHeight);
	void Draw(GLTextureManager &textureManager);
	void CalculateNormals();
	BOOL LoadFromBMP(char* pszPathFilename);
	void SetAltitude(float fAlt);

	float *pfMap;
	Vector3f *pNormals;
	int iWidth;
	int iHeight;

	int iTextureID;
};

#endif // !defined(AFX_TERRAINMAP_H__45DD064E_80D5_11D5_B3C1_0050DA2CE9D2__INCLUDED_)
