// TerrainWindow.cpp: implementation of the TerrainWindow class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "TerrainWindow.h"
#include <gl\glut.h>

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

TerrainWindow::TerrainWindow() {
	camera.SetOrientation(
		-20.0f, 50.0f, 100.0f,	// eye
		0.0f, 0.0f, 0.0f,		// target
		0.0f, 1.0f, 0.0f);		// up
	map.Create(100, 100);
	if (!map.LoadFromBMP("mask.bmp")) {
		MessageBox(NULL, "Can't find mask.bmp", "ERROR", MB_OK);
	}
	int t = glRenderingContext.textureManager.FindUserTextureID(
		"texture.bmp");
	map.iTextureID = t;
	iMode = GL_SMOOTH;
}

TerrainWindow::~TerrainWindow() {
}

void TerrainWindow::DrawImpl(GLTextureManager &textureManager) {
	//
	// Clear screen
	//

	GLViewport::ClearColorAndDepthBuffer();

	//
	// Rotate it..
	//

	camera.ApplyToGLViewport();

	//
	// Setup lighting
	//

	glShadeModel(iMode);

	glEnable(GL_LIGHTING);

	GLfloat ambientLight[] = { 0.4f, 0.4f, 0.4f, 1.0f };
	GLfloat diffuseLight[] = { 0.8f, 0.8f, 0.8f, 1.0f };

//	glLightModelfv(GL_LIGHT_MODEL_AMBIENT, ambientLight);

	GLfloat lightPos[] = { -0.3f, 1.0f, -0.2f, 0.0f };
	glEnable(GL_LIGHT0);
	//glLightfv(GL_LIGHT0, GL_AMBIENT, ambientLight);
	//glLightfv(GL_LIGHT0, GL_DIFFUSE, diffuseLight);
	glLightfv(GL_LIGHT0, GL_POSITION, lightPos);


	glEnable(GL_COLOR_MATERIAL);
	glColorMaterial(GL_FRONT, GL_AMBIENT_AND_DIFFUSE);

	//glEnable(GL_NORMALIZE);

	//glEnable(GL_RESCALE_NORMALS);

	//
	// Draw
	//

	glPushMatrix();
	coords.Draw(textureManager);
	map.Draw(textureManager);
	glPopMatrix();

	glutSolidSphere(15.0f, 15, 15);
}

void TerrainWindow::OnSize(int w, int h) {
    GLWindow::OnSize(w, h);
	camera.SetViewportSize(GLViewport::iWidth, GLViewport::iHeight);
}

void TerrainWindow::OnBeginMouseDrag(int x, int y, int flags) {
	iDragX = x;
	iDragY = y;
}

void TerrainWindow::OnMouseDrag(int x, int y, int flags) {
	float dx = (float) (x - iDragX);
	float dy = (float) (y - iDragY);
	iDragX = x;
	iDragY = y;

	RECT rc;
	GetClientRect(hwnd, &rc);
	int w = rc.right;
	int h = rc.bottom;

	// Rotate:

	// Pitch: height of view = 90 deg = pi/2
	camera.ApplyPitch(dy*fPI / (h*2));
	// Yaw: width of view = 90 deg = pi/2
	camera.ApplyYaw(dx*fPI/(w*2.0f));
	InvalidateRect(hwnd, NULL, FALSE);

}

void TerrainWindow::OnKeyDown(int iKeyCode) {
	switch (iKeyCode) {
	case VK_UP:
		map.SetAltitude(1.1f);
		break;
	case VK_DOWN:
		map.SetAltitude(0.9f);
		break;
	case 'S':
		iMode = GL_SMOOTH;
		break;
	case 'F':
		iMode = GL_FLAT;
		break;
	}
	InvalidateRect(hwnd, NULL, FALSE);
}

