// TerrainWindow.h: interface for the TerrainWindow class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_TERRAINWINDOW_H__45DD064D_80D5_11D5_B3C1_0050DA2CE9D2__INCLUDED_)
#define AFX_TERRAINWINDOW_H__45DD064D_80D5_11D5_B3C1_0050DA2CE9D2__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include <tomaskovic\engine3d\GLWindow.h>
#include <tomaskovic\engine3d\GLTextureManager.h>
#include <tomaskovic\engine3d\Camera.h>
#include <tomaskovic\engine3d\CoordinateSystem_o3d.h>
#include <tomaskovic\engine3d\Math3d.h>

#include "TerrainMap.h"

class TerrainWindow : public GLWindow  
{
public:
	TerrainWindow();
	virtual ~TerrainWindow();

	void DrawImpl(GLTextureManager &textureManager);

	Camera camera;
	CoordinateSystem_o3d coords;
	TerrainMap map;

	void OnSize(int w, int h);
	void OnBeginMouseDrag(int x, int y, int flags);
	void OnMouseDrag(int x, int y, int flags);
	void OnKeyDown(int iKeyCode);

	int iMode;

private:
	int iDragX;
	int iDragY;

};

#endif // !defined(AFX_TERRAINWINDOW_H__45DD064D_80D5_11D5_B3C1_0050DA2CE9D2__INCLUDED_)
