/**
 * Autodesk3dsObject3dModel.cpp
 *
 * @author Matija Tomaskovic
 * @version 21-Jul-2001
 */

#include "Autodesk3dsObject3dModel.h"
#include <tomaskovic\util\FileInputStream.h>
#include <tomaskovic\util\BufferInputStream.h>
#include <tomaskovic\util\SuperString.h>
#include <tomaskovic\util\MemoryManager.h>


Autodesk3dsObject3dModel::Autodesk3dsObject3dModel(Autodesk3dsDatabase *pAutodesk3dsDatabase, char* pszMeshName) {
	this->pAutodesk3dsDatabase = pAutodesk3dsDatabase;
    this->pMesh = pAutodesk3dsDatabase->GetMeshByName(pszMeshName);
	this->strName.Set(pMesh->szName);
}

Autodesk3dsObject3dModel::~Autodesk3dsObject3dModel() {
}

void Autodesk3dsObject3dModel::Draw(GLTextureManager &textureManager) {

	if ((!pAutodesk3dsDatabase) || (!pMesh))
		return;

    // Draw active mesh
	glDisable(GL_TEXTURE_2D);
	glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);

    // Paint every triangle face
    glBegin(GL_TRIANGLES);

	A3DS_VERTEX *pVertex1;
	A3DS_VERTEX *pVertex2;
	A3DS_VERTEX *pVertex3;
    for (int t=0; t<pMesh->wFaces; t++) {
        A3DS_FACE* pFace = &pMesh->faceArray[t];

		glColor4f(0.0f, 0.0f, 1.0f, 1.0f);

        pVertex1 = &pMesh->vertexArray[pFace->wVertexIndex1];
        pVertex2 = &pMesh->vertexArray[pFace->wVertexIndex2];
        pVertex3 = &pMesh->vertexArray[pFace->wVertexIndex3];
        glVertex3f(pVertex1->x, pVertex1->y, pVertex1->z);
        glVertex3f(pVertex2->x, pVertex2->y, pVertex2->z);
        glVertex3f(pVertex3->x, pVertex3->y, pVertex3->z);
    }

    glEnd();
}


void Autodesk3dsObject3dModel::DrawWireframe() {

	if ((!pAutodesk3dsDatabase) || (!pMesh))
		return;

    // Draw active mesh
	glDisable(GL_TEXTURE_2D);
	glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);

    // Paint every triangle face
    glBegin(GL_TRIANGLES);

	A3DS_VERTEX *pVertex1;
	A3DS_VERTEX *pVertex2;
	A3DS_VERTEX *pVertex3;
    for (int t=0; t<pMesh->wFaces; t++) {
        A3DS_FACE* pFace = &pMesh->faceArray[t];

		glColor4f(0.0f, 0.0f, 1.0f, 1.0f);

        pVertex1 = &pMesh->vertexArray[pFace->wVertexIndex1];
        pVertex2 = &pMesh->vertexArray[pFace->wVertexIndex2];
        pVertex3 = &pMesh->vertexArray[pFace->wVertexIndex3];
        glVertex3f(pVertex1->x, pVertex1->y, pVertex1->z);
        glVertex3f(pVertex2->x, pVertex2->y, pVertex2->z);
        glVertex3f(pVertex3->x, pVertex3->y, pVertex3->z);
    }

    glEnd();
}


void Autodesk3dsObject3dModel::GetBounds(float *pMinX, float *pMaxX, float *pMinY, float *pMaxY, float *pMinZ, float *pMaxZ)
{
	if ((!pAutodesk3dsDatabase) || (!pMesh))
		return;

	float fMinX, fMaxX, fMinY, fMaxY, fMinZ, fMaxZ;

	for (int i=0; i<pMesh->wVertices; i++) {
		A3DS_VERTEX* pVertex = &pMesh->vertexArray[i];

		if (i == 0) {
			fMinX = pVertex->x;
			fMaxX = pVertex->x;
			fMinY = pVertex->y;
			fMaxY = pVertex->y;
			fMinZ = pVertex->z;
			fMaxZ = pVertex->z;
		}
		else {
			if (pVertex->x < fMinX) fMinX = pVertex->x;
			if (pVertex->x > fMaxX) fMaxX = pVertex->x;
			if (pVertex->y < fMinY) fMinY = pVertex->y;
			if (pVertex->y > fMaxY) fMaxY = pVertex->y;
			if (pVertex->z < fMinZ) fMinZ = pVertex->z;
			if (pVertex->z > fMaxZ) fMaxZ = pVertex->z;
		}
	}

	*pMinX = fMinX;
	*pMaxX = fMaxX;
	*pMinY = fMinY;
	*pMaxY = fMaxY;
	*pMinZ = fMinZ;
	*pMaxZ = fMaxZ;
}

