/**
 * Autodesk3dsObject3dModel.h
 *
 * Autodesk3dsObject3dModel is implementation of Object3dModel
 * that uses mesh from Autodesk3dsDatabase (you must give pointers
 * to mesh and Autodesk3dsDatabase when constructing this object).
 *
 * @author Matija Tomaskovic
 * @version 21-Jul-2001
 */

#if !defined(_Autodesk3dsObject3dModel_H__INCLUDED_)
#define _Autodesk3dsObject3dModel_H__INCLUDED_

#include <windows.h>
#include "Object3dModel.h"
#include "GLTextureManager.h"
#include <tomaskovic\util\Buffer.h>
#include <tomaskovic\util\InputStream.h>
#include <tomaskovic\util\Vector.h>
#include "Autodesk3dsDatabase.h"


class Autodesk3dsObject3dModel : public Object3dModel
{
public:

    Autodesk3dsObject3dModel(Autodesk3dsDatabase *pAutodesk3dsDatabase, char* pszMeshName);
    ~Autodesk3dsObject3dModel();

    void Draw(GLTextureManager &textureManager);
	void DrawWireframe();

	void GetBounds(float* pMinX, float* pMaxX, float* pMinY, float* pMaxY, float* pMinZ, float* pMaxZ);

	Autodesk3dsDatabase *pAutodesk3dsDatabase;
	A3DS_MESH* pMesh;

};

#endif // !defined(_Autodesk3dsObject3dModel_H__INCLUDED_)
