/**
 * CoordinateSystem_o3d.cpp
 *
 * @author Matija Tomaskovic
 * @version 22-May-2001
 */

#include "CoordinateSystem_o3d.h"

#define WIN32_LEAN_AND_MEAN
#include <windows.h>

#include <tomaskovic\engine3d\glutil.h>
#include <gl\gl.h>              // Header File For The OpenGL32 Library
#include <gl\glu.h>             // Header File For The GLu32 Library

#include "CoordinateSystem_o3d.h"

CoordinateSystem_o3d::CoordinateSystem_o3d() {
    fCharSize = 1.0f;
	fCharPosition = 10.0f;

	fXGrid = 5.0f;
	fYGrid = 5.0f;
	fZGrid = 5.0f;

	fXMin = -100.0f;
	fXMax = 100.0f;

	fYMin = -100.0f;
	fYMax = 100.0f;

	fZMin = -100.0f;
	fZMax = 100.0f;

	isXYPlaneVisible = false;
	isXZPlaneVisible = true;
	isZYPlaneVisible = false;

	colorX = RGB(255,   0,   0);
	colorY = RGB(  0, 255,   0);
	colorZ = RGB(  0,   0, 255);

	colorXgrid = RGB(120,   0,   0);
	colorYgrid = RGB(  0, 100,   0);
	colorZgrid = RGB(  0,   0, 128);

}


void CoordinateSystem_o3d::Draw(GLTextureManager &textureManager) {


    //
    // Paint planes
    //

	glBegin(GL_LINES);

		// XZ plane
        if (isXZPlaneVisible) {
			glColorRGB(colorYgrid);
			float z;
            for (z=0.0f; z<fZMax; z+=fZGrid) {
                glVertex3f(fXMin, 0.0f, z);
                glVertex3f(fXMax, 0.0f, z);
            }
            for (z=0.0f; z>fZMin; z-=fZGrid) {
                glVertex3f(fXMin, 0.0f, z);
                glVertex3f(fXMax, 0.0f, z);
            }
			float x;
            for (x=0.0f; x<fXMax; x+=fXGrid) {
                glVertex3f(x, 0.0f, fZMin);
                glVertex3f(x, 0.0f, fZMax);
            }
            for (x=0.0f; x>fXMin; x-=fXGrid) {
                glVertex3f(x, 0.0f, fZMin);
                glVertex3f(x, 0.0f, fZMax);
            }
        }

		// XY plane
        if (isXYPlaneVisible) {
			glColorRGB(colorZgrid);
			float x;
            for (x=0.0f; x<fXMax; x+=fXGrid) {
                glVertex3f(x, fYMin, 0.0f);
                glVertex3f(x, fYMax, 0.0f);
            }
            for (x=0.0f; x>fXMin; x-=fXGrid) {
                glVertex3f(x, fYMin, 0.0f);
                glVertex3f(x, fYMax, 0.0f);
            }
			float y;
            for (y=0.0f; y<fYMax; y+=fYGrid) {
                glVertex3f(fXMin, y, 0.0f);
                glVertex3f(fXMax, y, 0.0f);
            }
            for (y=0.0f; y>fYMin; y-=fYGrid) {
                glVertex3f(fXMin, y, 0.0f);
                glVertex3f(fXMax, y, 0.0f);
            }
        }

	glEnd();

    //
    // Paint axes
    //

	glBegin(GL_LINES);

        // X axes
		glColorRGB(colorX);
        glVertex3f(fXMin, 0.0f, 0.0f);
        glVertex3f( 0.0f, 0.0f, 0.0f);
		glColor3ub(255, 255, 255);
        glVertex3f( 0.0f, 0.0f, 0.0f);
        glVertex3f(fCharPosition, 0.0f, 0.0f);
		glColorRGB(colorX);
        glVertex3f(fCharPosition, 0.0f, 0.0f);
        glVertex3f(fXMax, 0.0f, 0.0f);

        // Y axes
		glColorRGB(colorY);
        glVertex3f(0.0f, fYMin, 0.0f);
        glVertex3f(0.0f,  0.0f, 0.0f);
		glColor3ub(255, 255, 255);
        glVertex3f(0.0f,  0.0f, 0.0f);
        glVertex3f(0.0f, fCharPosition, 0.0f);
		glColorRGB(colorY);
        glVertex3f(0.0f, fCharPosition, 0.0f);
        glVertex3f(0.0f, fYMax, 0.0f);

        // Z axes
		glColorRGB(colorZ);
        glVertex3f(0.0f, 0.0f, fZMin);
        glVertex3f(0.0f, 0.0f,  0.0f);
		glColor3ub(255, 255, 255);
        glVertex3f(0.0f, 0.0f,  0.0f);
        glVertex3f(0.0f, 0.0f, fCharPosition);
		glColorRGB(colorZ);
        glVertex3f(0.0f, 0.0f, fCharPosition);
        glVertex3f(0.0f, 0.0f, fZMax);

	glEnd();

    //
    // Paint characters
    //

	// X sign
	glColorRGB(colorX);
    glPushMatrix();
        glTranslatef(fCharPosition, fCharSize/2.0f, 0.0f);
		glBegin(GL_LINES);
			glVertex3f(0.0f,      0.0f,         0.0f);
			glVertex3f(fCharSize, fCharSize,    0.0f);
			glVertex3f(0.0f,      fCharSize,    0.0f);
			glVertex3f(fCharSize, 0.0f,         0.0f);
		glEnd();
    glPopMatrix();

	// Y sign
	glColorRGB(colorY);
    glPushMatrix();
        glTranslatef(fCharSize/2, fCharPosition, 0.0f);
		glBegin(GL_LINES);
			glVertex3f(fCharSize/2, 0.0f, 0.0f);
			glVertex3f(fCharSize/2, fCharSize/2, 0.0f);
			glVertex3f(fCharSize/2, fCharSize/2, 0.0f);
			glVertex3f(0.0f, fCharSize, 0.0f);
			glVertex3f(fCharSize/2, fCharSize/2, 0.0f);
			glVertex3f(fCharSize, fCharSize, 0.0f);
		glEnd();
    glPopMatrix();

	// Z sign
	glColorRGB(colorZ);
    glPushMatrix();
        glTranslatef(fCharSize/2.0f, fCharSize/2.0f, fCharPosition);
		glBegin(GL_LINES);
			glVertex3f(0.0f,      0.0f,      0.0f);
			glVertex3f(fCharSize, fCharSize, 0.0f);
			glVertex3f(0.0f,      fCharSize, 0.0f);
			glVertex3f(fCharSize, fCharSize, 0.0f);
			glVertex3f(0.0f,      0.0f,      0.0f);
			glVertex3f(fCharSize, 0.0f,      0.0f);
		glEnd();
    glPopMatrix();

}
