/**
 * CoordinateSystem_o3d.h
 *
 * @author Matija Tomaskovic
 * @version 21-May-2001
 */

#if !defined(__COORDINATE_SYSTEM_O3D_H__INCLUDED__)
#define __COORDINATE_SYSTEM_O3D_H__INCLUDED__

#include <windows.h>
#include "Object3d.h"
#include "GLTextureManager.h"

class CoordinateSystem_o3d : public Object3d
{
public:

	CoordinateSystem_o3d();

    void Draw(GLTextureManager &glTextureManager);

    float fXGrid;
    float fYGrid;
	float fZGrid;

    // Borders of axes

    float fXMin;
    float fXMax;

    float fYMin;
    float fYMax;

    float fZMin;
    float fZMax;

    // Character size

    float fCharSize;
	float fCharPosition;

    // Planes to pain

    bool isXYPlaneVisible;
    bool isXZPlaneVisible;
    bool isZYPlaneVisible;

	COLORREF colorX;
	COLORREF colorY;
	COLORREF colorZ;

	COLORREF colorXgrid;
	COLORREF colorYgrid;
	COLORREF colorZgrid;

};

#endif // !defined(__COORDINATE_SYSTEM_O3D_H__INCLUDED__)
