/**
 * GLChildWindow.cpp
 *
 * @author Matija Tomaskovic
 * @version 13-Jun-2001
 */

#include <windows.h>
#include "GLChildWindow.h"
#include <tomaskovic\util\Vector.h>
#include <tomaskovic\util\SuperLog.h>

char szGLChildWindowClassName[] = "GLChildWindow";
BOOL isOpenGLChildClassRegistered = FALSE;

Vector vGLChildWindows;

GLChildWindow::GLChildWindow() {
    hwnd = NULL;
    vGLChildWindows.AddElement(this);
	isLButtonDown = FALSE;
}

GLChildWindow::~GLChildWindow() {
    vGLChildWindows.RemoveElement(this);
}

long FAR PASCAL OpenGLBaseChildWndProc( HWND hWnd, UINT iMsg, WPARAM wParam, LPARAM lParam )
{
    // Find pWnd for hWnd
    GLChildWindow* pWnd = NULL;
    for (int i=0; i<vGLChildWindows.Size(); i++) {
        GLChildWindow* p = (GLChildWindow*) vGLChildWindows.ElementAt(i);
        if (p->hwnd == hWnd) {
            pWnd = p;
			break;
		}
	}

    if ((iMsg == WM_CREATE) && (pWnd == NULL)) {
		CREATESTRUCT *pCS = (CREATESTRUCT*) lParam;
        pWnd = (GLChildWindow*) pCS->lpCreateParams;
        pWnd->hwnd = hWnd;
	}


	if (pWnd == NULL)
		return DefWindowProc(hWnd, iMsg, wParam, lParam);
	else
        return pWnd->DoWndProc(hWnd, iMsg, wParam, lParam);
}


long GLChildWindow::DoWndProc( HWND hWnd, UINT iMsg, WPARAM wParam, LPARAM lParam )
{
    switch(iMsg)
	{
        case WM_PAINT:
            SuperLog::logLn("W3M", "GLChildWindow::WM_PAINT");
			OnPaint();
			return 0;

		case WM_LBUTTONDOWN:
		{
			int fwKeys = wParam;        // key flags
			int xPos = LOWORD(lParam);  // horizontal position of cursor
			int yPos = HIWORD(lParam);  // vertical position of cursor
			if (xPos > 32768) xPos = xPos - 65536;
			if (yPos > 32768) yPos = yPos - 65536;
			OnLButtonDown(xPos, yPos, fwKeys);
			return 0;
		}

		case WM_LBUTTONUP:
		{
			int fwKeys = wParam;        // key flags
			int xPos = LOWORD(lParam);  // horizontal position of cursor
			int yPos = HIWORD(lParam);  // vertical position of cursor
			if (xPos > 32768) xPos = xPos - 65536;
			if (yPos > 32768) yPos = yPos - 65536;
			OnLButtonUp(xPos, yPos, fwKeys);
			return 0;
		}

		case WM_MOUSEMOVE:
		{
			int fwKeys = wParam;        // key flags
			int xPos = LOWORD(lParam);  // horizontal position of cursor
			int yPos = HIWORD(lParam);  // vertical position of cursor
			if (xPos > 32768) xPos = xPos - 65536;
			if (yPos > 32768) yPos = yPos - 65536;
			OnMouseMove(xPos, yPos, fwKeys);
			return 0;
		}

        case WM_CREATE:
			return 0;
			break;

		case WM_CLOSE:
            break;

		case WM_SIZE:
		{
			int fwSizeType = wParam;      // resizing flag
			int nWidth = LOWORD(lParam);  // width of client area
			int nHeight = HIWORD(lParam); // height of client area
			OnSize(nWidth, nHeight);
			return 0;
		}

		case WM_DESTROY:
			// PostQuitMessage(0);
			break;
	}

	return DefWindowProc(hWnd, iMsg, wParam, lParam);
}


BOOL GLChildWindow::Create(HINSTANCE hInstance, HWND hwndParent,
    int x, int y, int width, int height, int iBitsPerPixel)
{
	WNDCLASS  wc;

	this->hInstance = hInstance;

    if (!isOpenGLChildClassRegistered) {
        wc.style          = CS_HREDRAW | CS_VREDRAW | CS_OWNDC;
        wc.lpfnWndProc    = OpenGLBaseChildWndProc;
        wc.cbClsExtra     = 0;
        wc.cbWndExtra     = 0;
        wc.hInstance      = hInstance;
        wc.hIcon          = NULL;
        wc.hCursor        = LoadCursor(NULL, IDC_ARROW);
        wc.hbrBackground  = NULL;
        wc.lpszMenuName   = NULL;
        wc.lpszClassName  = szGLChildWindowClassName;

        if (!RegisterClass(&wc)) {
            MessageBox(NULL, "Register GLChildWindow class failed!", "ERROR", MB_OK);
            return FALSE;
        }

        isOpenGLChildClassRegistered = TRUE;
    }

    hwnd = CreateWindow(
        szGLChildWindowClassName,
		NULL,		// No tittle
		WS_CHILD,	//  | WS_BORDER
		x, y, width, height,
        hwndParent, NULL, hInstance, this);

    if (!(hDC = GetDC(hwnd))) {
        ::MessageBox(NULL, "Can't Create A GL Device Context.", "ERROR", MB_OK);
		return FALSE;
    }

	// Create rendering context
	if (!glRenderingContext.Create(hDC, iBitsPerPixel))
		return FALSE;

	// Create viewport
	GLViewport::SetViewportRect(0, 0, width, height);

	glRenderingContext.AddGLViewport(this);

    ShowWindow(hwnd, SW_SHOW);
    UpdateWindow(hwnd);

	return TRUE;
}



void GLChildWindow::OnPaint() {
	PAINTSTRUCT ps;
    BeginPaint(hwnd, &ps);
	glRenderingContext.Draw();
	EndPaint(hwnd, &ps);
}

void GLChildWindow::OnLButtonDown(int x, int y, int flags) {
	isLButtonDown = TRUE;
	::SetCapture(hwnd);
	OnBeginMouseDrag(x, y, flags);
}

void GLChildWindow::OnMouseMove(int x, int y, int flags) {
	if (isLButtonDown)
		OnMouseDrag(x, y, flags);
}

void GLChildWindow::OnLButtonUp(int x, int y, int flags) {
	OnEndMouseDrag(x, y, flags);
	isLButtonDown = FALSE;
	::ReleaseCapture();
}

void GLChildWindow::OnSize(int w, int h) {
	GLViewport::SetViewportRect(0, 0, w, h);
}

void GLChildWindow::OnBeginMouseDrag(int x, int y, int flags) {
}

void GLChildWindow::OnMouseDrag(int x, int y, int flags) {
}

void GLChildWindow::OnEndMouseDrag(int x, int y, int flags) {
}
