/**
 * GLRenderingContext.cpp
 *
 * @author Matija Tomaskovic
 * @version 23-Jul-2001
 */

#include "GLRenderingContext.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

GLRenderingContext::GLRenderingContext() {
	hDC = NULL;
	hRC = NULL;
}

GLRenderingContext::~GLRenderingContext() {
    Destroy();
}

BOOL GLRenderingContext::Create(HDC hDC, int iBitsPerPixel)
{
    //
    // Set PixelFormat
    //

	this->hDC = hDC;

    PIXELFORMATDESCRIPTOR pfd=      // pfd Tells Windows How We Want Things To Be
    {
        sizeof(PIXELFORMATDESCRIPTOR),      // Size Of This Pixel Format Descriptor
        1,                                  // Version Number
        PFD_DRAW_TO_WINDOW |                // Format Must Support Window
        PFD_SUPPORT_OPENGL |                // Format Must Support OpenGL
        PFD_DOUBLEBUFFER,                   // Must Support Double Buffering
        PFD_TYPE_RGBA,                      // Request An RGBA Format
        iBitsPerPixel,                      // Select Our Color Depth
        0, 0, 0, 0, 0, 0,                   // Color Bits Ignored
        0,                                  // No Alpha Buffer
        0,                                  // Shift Bit Ignored
        0,                                  // No Accumulation Buffer
        0, 0, 0, 0,                         // Accumulation Bits Ignored
        16,                                 // 16Bit Z-Buffer (Depth Buffer)
        0,                                  // No Stencil Buffer
        0,                                  // No Auxiliary Buffer
        PFD_MAIN_PLANE,                     // Main Drawing Layer
        0,                                  // Reserved
        0, 0, 0                             // Layer Masks Ignored
    };

    memcpy(&pixelFormatDescriptor, &pfd, sizeof(PIXELFORMATDESCRIPTOR));

    GLuint      PixelFormat;                // Holds The Results After Searching For A Match

	// Did Windows Find A Matching Pixel Format?
    if (!(PixelFormat=ChoosePixelFormat(hDC, &pixelFormatDescriptor)))
    {
        MessageBox(NULL,"Can't Find A Suitable PixelFormat.","ERROR",MB_OK|MB_ICONEXCLAMATION);
        return FALSE;
    }

	// Are We Able To Set The Pixel Format?
    if(!SetPixelFormat(hDC, PixelFormat, &pixelFormatDescriptor))
    {
        MessageBox(NULL,"Can't Set The PixelFormat.","ERROR",MB_OK|MB_ICONEXCLAMATION);
        return FALSE;
    }

    //
    // Create Rendering Context
    //

    if (!(hRC=wglCreateContext(hDC)))
    {
        MessageBox(NULL,"Can't Create A GL Rendering Context.","ERROR",MB_OK|MB_ICONEXCLAMATION);
        return FALSE;
    }


	return TRUE;
}


void GLRenderingContext::Destroy() {
    // Delete RC
    if (hRC) {
        if (!wglMakeCurrent(NULL, NULL)) {
            MessageBox(NULL,"Release Of DC And RC Failed.","SHUTDOWN ERROR",MB_OK | MB_ICONINFORMATION);
        }

        if (!wglDeleteContext(hRC)) {
            MessageBox(NULL,"Release Rendering Context Failed.","SHUTDOWN ERROR",MB_OK | MB_ICONINFORMATION);
        }

        hRC=NULL;
    }
}


void GLRenderingContext::AddGLViewport(GLViewport* pGLViewport) {
    vGLViewports.AddElement(pGLViewport);
}

void GLRenderingContext::Draw() {

    // Activate RC for DC
    if(!wglMakeCurrent(hDC, hRC)) {
        MessageBox(NULL,"Can't Activate The GL Rendering Context.","ERROR",MB_OK|MB_ICONEXCLAMATION);
        return;
    }

    // Draw all viewports
    for (int i=0; i<vGLViewports.Size(); i++) {
		GLViewport* pGLViewport = (GLViewport*) vGLViewports.ElementAt(i);
		pGLViewport->Draw(textureManager);
    }

    // Copy backbuffer to screen
	SwapBuffers(hDC);
}

