/**
 * GLRenderingContext.h
 * Interface for the GLRenderingContext class.
 *
 * DESCRIPTION:
 *
 * GLRenderingContext class creates OpenGL Rendering Context (RC) on
 * given hDC, and does repainting of GLViewports that you have on that hDC.
 * When using OpenGL API to paint on your window's device context (HDC),
 * you must create OpenGL Rendering Context for that HDC.
 * Every GLRenderingContext you are using is having its own GLTextureManager
 * because OpenGL can't share loaded textures between different
 * Rendering Contexts.
 *
 * USAGE:
 *
 *      // Create your window (with CS_OWNDC style in your WNDCLASS!)
 *          // ... you should know this ...
 *
 *      // Create instance of GLRenderingContext
 *          GLRenderingContext glRenderingContext;
 *
 *      // Activate it on your HDC with desired iBitsPerPixel (e.g. 24)
 *          glRenderingContext.Create(hYourDC, 24);
 *
 *      // Add your GLViewports (you should create ones on your window)
 *          glRenderingContext.AddGLViewport(pYourGLViewport);
 *
 *      // When you want to repaint viewports on your HDC call:
 *          glRenderingContext.Draw();
 *
 * @author Matija Tomaskovic
 * @version 23-May-2001
 */

#if !defined(_GLRenderingContext_H__INCLUDED_)
#define _GLRenderingContext_H__INCLUDED_

#include <windows.h>

#include <gl\gl.h>              // Header File For The OpenGL32 Library
#include <gl\glu.h>             // Header File For The GLu32 Library

#include "GLViewport.h"
#include "GLTextureManager.h"

#include <tomaskovic\util\Vector.h>


class GLRenderingContext
{
public:
    GLRenderingContext();
    virtual ~GLRenderingContext();

    BOOL Create(HDC hDC, int iBitsPerPixel);
	void Destroy();

    void AddGLViewport(GLViewport* pGLViewport);

    void Draw();

	HGLRC hRC;
	HDC hDC;

    GLTextureManager textureManager;

private:
    PIXELFORMATDESCRIPTOR pixelFormatDescriptor;
    Vector vGLViewports;

};

#endif // !defined(_GLRenderingContext_H__INCLUDED_)
