/**
 * GLViewport.cpp
 * Implementation of the GLViewport class.
 *
 * @author Matija Tomaskovic
 * @version 21-May-2001
 */

#include "glutil.h"
#include "GLViewport.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

GLViewport::GLViewport() {
    x = 0;
    y = 0;
    iWidth = 0;
    iHeight = 0;
	colorBackground = RGB(0, 0, 0);
}

GLViewport::~GLViewport() {
}

void GLViewport::SetViewportRect(int x, int y, int width, int height) {
    this->x = x;
    this->y = y;
    this->iWidth = width;
    this->iHeight = height;
}

void GLViewport::Destroy() {
}


void GLViewport::Draw(GLTextureManager &textureManager) {

    // Set GL viewport
    glViewport(x, y, iWidth, iHeight);

	glEnable(GL_DEPTH_TEST);
	glDepthFunc(GL_LEQUAL);

	glShadeModel(GL_SMOOTH);

	glDepthRange(0.0, 1.0);

    //glEnable(GL_CULL_FACE);
    //glFrontFace(GL_CCW);
	// glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);

	//
	// Lighting
	//
/*
	glEnable(GL_LIGHTING);

	GLfloat ambientLight[] = { 0.3f, 0.3f, 0.3f, 1.0f };
	GLfloat diffuseLight[] = { 0.7f, 0.7f, 0.7f, 1.0f };

	glLightfv(GL_LIGHT0, GL_AMBIENT, ambientLight);
	glLightfv(GL_LIGHT0, GL_DIFFUSE, diffuseLight);
	glEnable(GL_LIGHT0);

	glEnable(GL_NORMALIZE);
	//glEnable(GL_RESCALE_NORMALS);

	//glLightModelfv(GL_LIGHT_MODEL_AMBIENT, ambientLight);

	glEnable(GL_COLOR_MATERIAL);
	glColorMaterial(GL_FRONT, GL_AMBIENT_AND_DIFFUSE);
	*/

	//
	// Initialization of viewport
	//

	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();

	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();

    // Call DrawImpl of child class
    DrawImpl(textureManager);
}

void GLViewport::ClearColorBuffer() {
	float fColor[4];
	colorref_to_color4f(colorBackground, fColor);
	fColor[3] = 0.0f;

	glClearColor(fColor[0], fColor[1], fColor[2], fColor[3]);
	glClear(GL_COLOR_BUFFER_BIT);
}

void GLViewport::ClearDepthBuffer() {
	glClear(GL_DEPTH_BUFFER_BIT);
}

void GLViewport::ClearColorAndDepthBuffer() {
	float fColor[4];
	colorref_to_color4f(colorBackground, fColor);
	fColor[3] = 1.0f;

	glClearColor(fColor[0], fColor[1], fColor[2], fColor[3]);
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
}
