/**
 * GLViewport.cpp
 * Interface for the GLViewport class.
 *
 * DESCRIPTION:
 * GLViewport class represents OpenGL viewport on your Device Context (DC).
 * You can have multiple GLViewports on single DC, but all of them are
 * inserted into single GLRenderingContext you have attached to your DC.
 *
 * USAGE:
 *      // Extend GLViewport class implementing DrawImpl(...) method
 *
 *      // Add your class to GLRenderingContext of your DC
 *          glRenderingContext.AddGLViewport(pYourGLViewportBasedClass);
 *
 *      // Set viewport rect (position and size) on DC
 *          pYourGLViewportBasedClass->SetViewportRect(0, 0, 320, 240);
 *
 *      // Set background color (if you're going to clear surface with
 *      // this viewport)
 *          pYourGLViewportBasedClass->colorBackground = RGB(0, 0, 0);
 *
 *      // Later, when you call glRenderingContext.Draw(), it will call
 *      // Draw() of GLViewport that will bound OpenGL to given rectangle
 *      // on DC, and Draw() will call your DrawImpl(...) for actual
 *      // rendering
 *
 *      // In your DrawImpl, you should set-up OpenGL (lighting, textures,..)
 *      // but you can also use utility functions of GLViewport to clear
 *      // depth and color buffer, e.g.:
 *          GLViewport::ClearColorAndDepthBuffer();
 *
 * @author Matija Tomaskovic
 * @version 23-Jul-2001
 */

#if !defined(_GLViewport_H__INCLUDED_)
#define _GLViewport_H__INCLUDED_

#include "World3d.h"

#include <gl\gl.h>              // Header File For The OpenGL32 Library
#include <gl\glu.h>             // Header File For The GLu32 Library


class GLViewport
{
public:
    GLViewport();
    virtual ~GLViewport();

    void SetViewportRect(int x, int y, int width, int height);
	void Destroy();

    void Draw(GLTextureManager &glTextureManager);

    virtual void DrawImpl(GLTextureManager &glTextureManager) = 0;

    int x;
    int y;
	int iWidth;
	int iHeight;

	COLORREF colorBackground;

    //
    // Utility functions
    //

	void ClearColorAndDepthBuffer();
	void ClearDepthBuffer();
	void ClearColorBuffer();

};

#endif // !defined(_GLViewport_H__INCLUDED_)
