/**
 * GLWindow.cpp
 *
 * @author Matija Tomaskovic
 * @version 13-Jun-2001
 */

#include <windows.h>
#include "GLWindow.h"
#include <tomaskovic\util\Vector.h>
#include <tomaskovic\util\SuperLog.h>

char szGLWindowClassName[] = "GLWindow";
BOOL isGLWindowClassRegistered = FALSE;

Vector vGLWindows;

GLWindow::GLWindow() {
    hwnd = NULL;
    vGLWindows.AddElement(this);
	isLButtonDown = FALSE;
}

GLWindow::~GLWindow() {
    vGLWindows.RemoveElement(this);
}

long FAR PASCAL GLWndProc( HWND hWnd, UINT iMsg, WPARAM wParam, LPARAM lParam )
{
    // Find pWnd for hWnd
    GLWindow* pWnd = NULL;
    for (int i=0; i<vGLWindows.Size(); i++) {
        GLWindow* p = (GLWindow*) vGLWindows.ElementAt(i);
        if (p->hwnd == hWnd) {
            pWnd = p;
			break;
		}
	}

    if ((iMsg == WM_CREATE) && (pWnd == NULL)) {
		CREATESTRUCT *pCS = (CREATESTRUCT*) lParam;
        pWnd = (GLWindow*) pCS->lpCreateParams;
        pWnd->hwnd = hWnd;
	}


	if (pWnd == NULL)
		return DefWindowProc(hWnd, iMsg, wParam, lParam);
	else
        return pWnd->DoWndProc(hWnd, iMsg, wParam, lParam);
}


long GLWindow::DoWndProc( HWND hWnd, UINT iMsg, WPARAM wParam, LPARAM lParam )
{
    switch(iMsg)
	{
        case WM_PAINT:
            SuperLog::logLn("W3M", "GLWindow::WM_PAINT");
			OnPaint();
			return 0;

		case WM_LBUTTONDOWN:
		{
			int fwKeys = wParam;        // key flags
			int xPos = LOWORD(lParam);  // horizontal position of cursor
			int yPos = HIWORD(lParam);  // vertical position of cursor
			if (xPos > 32768) xPos = xPos - 65536;
			if (yPos > 32768) yPos = yPos - 65536;
			OnLButtonDown(xPos, yPos, fwKeys);
			return 0;
		}

		case WM_LBUTTONUP:
		{
			int fwKeys = wParam;        // key flags
			int xPos = LOWORD(lParam);  // horizontal position of cursor
			int yPos = HIWORD(lParam);  // vertical position of cursor
			if (xPos > 32768) xPos = xPos - 65536;
			if (yPos > 32768) yPos = yPos - 65536;
			OnLButtonUp(xPos, yPos, fwKeys);
			return 0;
		}

		case WM_MOUSEMOVE:
		{
			int fwKeys = wParam;        // key flags
			int xPos = LOWORD(lParam);  // horizontal position of cursor
			int yPos = HIWORD(lParam);  // vertical position of cursor
			if (xPos > 32768) xPos = xPos - 65536;
			if (yPos > 32768) yPos = yPos - 65536;
			OnMouseMove(xPos, yPos, fwKeys);
			return 0;
		}

        case WM_CREATE:
			return 0;
			break;

		case WM_CLOSE:
			PostQuitMessage(0);
            break;

		case WM_KEYDOWN:
			OnKeyDown((int) wParam);
			return 0;

		case WM_KEYUP:
			OnKeyUp((int) wParam);
			return 0;

		case WM_SIZE:
		{
			int fwSizeType = wParam;      // resizing flag
			int nWidth = LOWORD(lParam);  // width of client area
			int nHeight = HIWORD(lParam); // height of client area
			OnSize(nWidth, nHeight);
			return 0;
		}

		case WM_DESTROY:
			// PostQuitMessage(0);
			break;
	}

	return DefWindowProc(hWnd, iMsg, wParam, lParam);
}


BOOL GLWindow::Create(HINSTANCE hInstance, HWND hwndParent,
    int x, int y, int width, int height, int iBitsPerPixel)
{
    WNDCLASS  wc;

	this->hInstance = hInstance;

    if (!isGLWindowClassRegistered) {
        wc.style          = CS_HREDRAW | CS_VREDRAW | CS_OWNDC;
        wc.lpfnWndProc    = GLWndProc;
        wc.cbClsExtra     = 0;
        wc.cbWndExtra     = 0;
        wc.hInstance      = hInstance;
        wc.hIcon          = LoadIcon(NULL, IDI_WINLOGO);
        wc.hCursor        = LoadCursor(NULL, IDC_ARROW);
        wc.hbrBackground  = NULL;
        wc.lpszMenuName   = NULL;
        wc.lpszClassName  = szGLWindowClassName;

        if (!RegisterClass(&wc)) {
            MessageBox(NULL, "Register GLWindow class failed!", "ERROR", MB_OK);
            return FALSE;
        }

        isGLWindowClassRegistered = TRUE;
    }

    DWORD   dwExStyle;
    DWORD	dwStyle;
    dwExStyle = WS_EX_APPWINDOW | WS_EX_WINDOWEDGE;
    dwStyle = WS_OVERLAPPEDWINDOW;

    // Adjust Window To True Requested Size
    RECT WindowRect;
    WindowRect.left = 0;
    WindowRect.right = width;
    WindowRect.top = 0;
    WindowRect.bottom = height;
    AdjustWindowRectEx(&WindowRect, dwStyle, FALSE, dwExStyle);

    hwnd = CreateWindowEx(
        dwExStyle,
        szGLWindowClassName,
        "GLWindow",       // No tittle
        WS_CLIPSIBLINGS | WS_CLIPCHILDREN | dwStyle,   //  | WS_BORDER
		x, y, width, height,
        hwndParent, NULL, hInstance, this);

    if (!(hDC = GetDC(hwnd))) {
        ::MessageBox(NULL, "Can't Create A GL Device Context.", "ERROR", MB_OK);
		return FALSE;
    }

	// Create rendering context
	if (!glRenderingContext.Create(hDC, iBitsPerPixel))
		return FALSE;

	// Create viewport
	GLViewport::SetViewportRect(0, 0, width, height);

	glRenderingContext.AddGLViewport(this);

    ShowWindow(hwnd, SW_SHOW);
    UpdateWindow(hwnd);

	return TRUE;
}



void GLWindow::OnPaint() {
	PAINTSTRUCT ps;
    BeginPaint(hwnd, &ps);
	glRenderingContext.Draw();
	EndPaint(hwnd, &ps);
}

void GLWindow::OnLButtonDown(int x, int y, int flags) {
	isLButtonDown = TRUE;
	::SetCapture(hwnd);
	OnBeginMouseDrag(x, y, flags);
}

void GLWindow::OnMouseMove(int x, int y, int flags) {
	if (isLButtonDown)
		OnMouseDrag(x, y, flags);
}

void GLWindow::OnLButtonUp(int x, int y, int flags) {
	OnEndMouseDrag(x, y, flags);
	isLButtonDown = FALSE;
	::ReleaseCapture();
}

void GLWindow::OnSize(int w, int h) {
	GLViewport::SetViewportRect(0, 0, w, h);
}

void GLWindow::OnBeginMouseDrag(int x, int y, int flags) {
}

void GLWindow::OnMouseDrag(int x, int y, int flags) {
}

void GLWindow::OnEndMouseDrag(int x, int y, int flags) {
}

void GLWindow::OnKeyDown(int iKeyCode) {
}

void GLWindow::OnKeyUp(int iKeyCode) {
}

