/**
 * GLWindow.h
 * Definition of GLWindow class
 *
 * DESCRIPTION:
 *
 * GLWindow class encapsulates win32 window with GLRenderingContext
 * on its DC, also this class extends GLViewport and inserts itself
 * into GLRenderingContext as only viewport on this window.
 * Use this class as base class for your class that will implement
 * DrawImpl(...) method.
 *
 * USAGE:
 *      // Derive your class from this one,
 *      // and implement DrawImpl(...) method
 *
 *      // Create instance of your class
 *          MyGLWindow myGLWindow;
 *
 *      // Create actual win32 window
 *          myGLWindow.Create(hInstance, hwndParent,
 *              10, 10, 320, 200, 24);
 *
 *  Here, window was created with OpenGL rendering context.
 *	OnPaint handler will use GLRenderingContext
 *	which will forward painting back to this window
 *  (it is only GLViewport in this context), and which
 *  will finally call DrawImpl(...) you will implement..
 *
 * @author Matija Tomaskovic
 * @version 23-Jul-2001
 */

#if !defined(_GLWindow_H__INCLUDED_)
#define _GLWindow_H__INCLUDED_

#include <windows.h>

#include "GLRenderingContext.h"
#include "GLViewport.h"
#include "Camera.h"


class GLWindow : public GLViewport {

public:
    GLWindow();
    virtual ~GLWindow();

    HWND hwnd;
	HINSTANCE hInstance;

    BOOL Create(HINSTANCE hInstance, HWND hwndParent,
		int x, int y, int width, int height, int iBitsPerPixel);

    virtual long DoWndProc(HWND hWnd, UINT iMsg, WPARAM wParam, LPARAM lParam);

	virtual void OnMouseMove(int x, int y, int flags);
	virtual void OnLButtonDown(int x, int y, int flags);
	virtual void OnLButtonUp(int x, int y, int flags);
	virtual void OnSize(int w, int h);

	virtual void OnBeginMouseDrag(int x, int y, int flags);
	virtual void OnMouseDrag(int x, int y, int flags);
	virtual void OnEndMouseDrag(int x, int y, int flags);

	virtual void OnKeyDown(int iKeyCode);
	virtual void OnKeyUp(int iKeyCode);

	BOOL isLButtonDown;

	GLRenderingContext glRenderingContext;

private:
	void OnPaint();

	HDC hDC;

};

#endif // !defined(_GLWindow_H__INCLUDED_)
