/**
 * glutil.cpp
 *
 * @author Matija Tomaskovic
 * @version 22-May-2001
 */

#include "glutil.h"

#include <windows.h>
#include <gl\gl.h>              // Header File For The OpenGL32 Library
#include <gl\glu.h>             // Header File For The GLu32 Library

void glColorRGB(COLORREF color) {
    glColor3ub( (BYTE) (color & 0xff),
                (BYTE) ((color & 0xff00) >> 8),
                (BYTE) ((color & 0xff0000) >> 16));
}

void colorref_to_color4f(COLORREF color, float *pColor4f) {
	float r = (float) ((color & 0xff));
	float g = (float) ((color & 0xff00) >> 8);
	float b = (float) ((color & 0xff0000) >> 16);
	pColor4f[0] = r / 255;
	pColor4f[1] = g / 255;
	pColor4f[2] = b / 255;
	pColor4f[3] = 1.0f;
}