/**
 * Object3dModel.h
 *
 * Object3dModel is base class for models of 3d objects.
 * Child class should implement Draw(...) and DrawWireframe() methods.
 * WavefrontObject3dModel and Autodesk3dsObject3dModel are useful
 * implementations of this class.
 *
 * @author Matija Tomaskovic
 * @version 24-Jul-2001
 */

#if !defined(_Object3dModel_H__INCLUDED_)
#define _Object3dModel_H__INCLUDED_

#include <tomaskovic\util\SuperString.h>
#include "GLTextureManager.h"

class Object3dModel
{
public:

    Object3dModel();
    ~Object3dModel();

    virtual void Draw(GLTextureManager &glTextureManager) = 0;
    virtual void DrawWireframe() = 0;

	virtual void GetBounds(float* pMinX, float* pMaxX, float* pMinY, float* pMaxY, float* pMinZ, float* pMaxZ) = 0;

	SuperString strName;
};

#endif // !defined(_Object3dModel_H__INCLUDED_)
