// Quaternion.cpp: implementation of the Quaternion class.
//
//////////////////////////////////////////////////////////////////////

#include "Quaternion.h"
#include "Matrix44f.h"
#include "Vector3f.h"

#include <math.h>

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

Quaternion::Quaternion() {
}

Quaternion::~Quaternion() {
}

void Quaternion::ConvertToMatrix(Matrix44f &destMatrix) {

	destMatrix.fValues[0][0] = 1 - 2*(y*y + z*z);
	destMatrix.fValues[0][1] = 2*(x*y - w*z);
	destMatrix.fValues[0][2] = 2*(w*y + x*z);
	destMatrix.fValues[0][3] = 0;

	destMatrix.fValues[1][0] = 2*(x*y + w*z);
	destMatrix.fValues[1][1] = 1 - 2*(x*x + z*z);
	destMatrix.fValues[1][2] = 2*(y*z - w*x);
	destMatrix.fValues[1][3] = 0;

	destMatrix.fValues[2][0] = 2*(x*z - w*y);
	destMatrix.fValues[2][1] = 2*(y*z + w*x);
	destMatrix.fValues[2][2] = 1 - 2*(x*x + y*y);
	destMatrix.fValues[2][3] = 0;

	destMatrix.fValues[3][0] = 0;
	destMatrix.fValues[3][1] = 0;
	destMatrix.fValues[3][2] = 0;
	destMatrix.fValues[3][3] = 1;
}

/**
 * Warning: vAxis must be normalized!
 */
void Quaternion::Set(Vector3f &vAxis, float fAngle) {
	float s = (float) sin(fAngle / 2);
	float c = (float) cos(fAngle / 2);
	x = s * vAxis.x;
	y = s * vAxis.y;
	z = s * vAxis.z;
	w = c;
}

void Quaternion::Normalize() {
	float fValue = (float) sqrt(x*x + y*y + z*z + w*w);
	x = x/fValue;
	y = y/fValue;
	z = z/fValue;
	w = w/fValue;
}
