// Vector3f.cpp: implementation of the Vector3f class.
//
//////////////////////////////////////////////////////////////////////

#include "Vector3f.h"
#include "Matrix44f.h"
#include <math.h>

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

Vector3f::Vector3f() {
}

Vector3f::Vector3f(Vector3f &original) {
	x = original.x;
	y = original.y;
	z = original.z;
}

Vector3f::~Vector3f() {
}

void Vector3f::Set(float x, float y, float z) {
	this->x = x;
	this->y = y;
	this->z = z;
}

void Vector3f::Substract(Vector3f& v) {
	x -= v.x;
	y -= v.y;
	z -= v.z;
}

void Vector3f::Add(Vector3f &v) {
	x += v.x;
	y += v.y;
	z += v.z;
}

void Vector3f::Set(Vector3f &v) {
	x = v.x;
	y = v.y;
	z = v.z;
}

void Vector3f::CrossProduct(Vector3f &v) {
	/*
		X  Y  Z
		x1 y1 z1
		x2 y2 z2

		X = y1z2 - y2z1
	*/
	float x;
	float y;
	float z;
	x = (this->y * v.z) - (this->z * v.y);
	y = (this->x * v.z) - (this->z * v.x);
	z = (this->x * v.y) - (this->y * v.x);
	this->x = x;
	this->y = y;
	this->z = z;
}

void Vector3f::CrossProduct(Vector3f &v1, Vector3f &v2) {
	/*
		X  Y  Z
		x1 y1 z1
		x2 y2 z2

		X = y1z2 - y2z1
	*/
	x = (v1.y * v2.z) - (v1.z * v2.y);
	y = (v1.x * v2.z) - (v1.z * v2.x);
	z = (v1.x * v2.y) - (v1.y * v2.x);
}

void Vector3f::Transform(Matrix44f &m) {
	/*
					  [ v v v v ]
		[ x y z 1 ] * | v v v v ]
		              | v v v v |
					  [ v v v v ]
	*/

	float xx;
	float yy;
	float zz;

	xx = x * m.fValues[0][0] +
		y * m.fValues[0][1] +
		z * m.fValues[0][2] +
		m.fValues[0][3];

	yy = x * m.fValues[1][0] +
		y * m.fValues[1][1] +
		z * m.fValues[1][2] +
		m.fValues[1][3];

	zz = x * m.fValues[2][0] +
		y * m.fValues[2][1] +
		z * m.fValues[2][2] +
		m.fValues[2][3];

	x = xx;
	y = yy;
	z = zz;
}

void Vector3f::Normalize() {
	float fValue = (float) sqrt(x*x + y*y + z*z);
	x = x/fValue;
	y = y/fValue;
	z = z/fValue;
}
