/**
 * WavefrontObject3dModel.h
 *
 * WavefrontObject3dModel class is implementation of Object3dModel that
 * uses 3d objects from Wavefront obj files.
 *
 * Notes:
 * WF = WAVEFRONT
 *
 * @author Matija Tomaskovic
 * @version 04-Jun-2001
 */

#if !defined(_WavefrontObject3dModel_H__INCLUDED_)
#define _WavefrontObject3dModel_H__INCLUDED_

#include <windows.h>
#include "Object3dModel.h"
#include "GLTextureManager.h"
#include <tomaskovic\util\Array.h>

#define UNDEFINED_FLOAT_VALUE	0.001976f

typedef struct {
    float x;
    float y;
    float z;
    float w;
} WF_GEOMETRIC_VERTEX;

typedef struct {
    float u;
    float v;
    float w;
} WF_TEXTURE_VERTEX;

typedef struct {
    float i;
    float j;
    float k;
} WF_VERTEX_NORMAL;

// WF_TRIANGLE_FACE is single triangle face having indexes of
// WF_GEOMETRIC_VERTEX, WF_TEXTURE_VERTEX and WF_VERTEX_NORMAL
// (-1 if some of them is not used)
typedef struct {
    int iGeometricVertexIndex[3];
    int iTextureVertexIndex[3];
    int iVertexNormalIndex[3];
} WF_TRIANGLE_FACE;

typedef struct {
    float fRed;
    float fGreen;
    float fBlue;
} WF_COLORF;

typedef struct {
    char szName[512];
    WF_COLORF colorAmbient;
    WF_COLORF colorDiffuse;
    WF_COLORF colorSpecular;
    float fShinnes;
    char szDiffuseMap[512];
    int iUserTextureID;  // this is user texture ID (generated as material number) - check TEXTURE.iUserTextureID
} WF_MATERIAL;

typedef struct {
    char szName[512];
    char szMaterialName[512];
    WF_MATERIAL*    pMaterial;
    int             iFirstFaceIndex;
    int             iFaces;
} WF_GROUP;


class WavefrontObject3dModel : public Object3dModel {

public:
    WavefrontObject3dModel();
    ~WavefrontObject3dModel();

    BOOL LoadFromFile(char* pszFilename);

    void Draw(GLTextureManager &glTextureManager);
	void DrawWireframe();

	void GetBounds(float* pMinX, float* pMaxX, float* pMinY, float* pMaxY, float* pMinZ, float* pMaxZ);

private:
	BOOL LoadMaterialsFromLibrary(char* pszMtlFilename);

    Array aGeometricVertices;
    Array aTextureVertices;
    Array aVertexNormals;
    Array aTriangleFaces;
    Array aMaterials;
    Array aGroups;

};

#endif // !defined(_WavefrontObject3dModel_H__INCLUDED_)
