/**
 * World3d.cpp
 * Implementation of the World3d class.
 *
 * @author Matija Tomaskovic
 * @version 21-May-2001
 */

#include <windows.h>
#include "World3d.h"

#include <gl\gl.h>              // Header File For The OpenGL32 Library
#include <gl\glu.h>             // Header File For The GLu32 Library


//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

World3d::World3d() {
}

World3d::~World3d() {
	Clear();
}


void World3d::AddObject3d(Object3d *pObject3d) {
    vObject3d.AddElement(pObject3d);
}


void World3d::Draw(GLTextureManager &textureManager) {
    // For each object in vector:
    for (int i=0; i<vObject3d.Size(); i++) {
        Object3d* pObject3d = (Object3d*) vObject3d.ElementAt(i);
        // Transform coordinate
        // system into object space
		glPushMatrix();
        glTranslatef(pObject3d->fX, pObject3d->fY, pObject3d->fZ);
        // Call pObject3d->Draw();
		pObject3d->Draw(textureManager);
		glPopMatrix();
	}
}

void World3d::Clear() {
	// Delete all objects
    for (int i=0; i<vObject3d.Size(); i++) {
        Object3d* pObject3d = (Object3d*) vObject3d.ElementAt(i);
		delete pObject3d;
	}
	vObject3d.Clear();
}
