/**
 * World3dModel.cpp
 * Interface for the World3dModel class.
 *
 * World3dModel represents collection of objects (3d objects
 * and cameras) in 3d world, with keyframes.
 * World3dModel has collection of model definitions (W3D_MODEL_DEFINITION)
 * used by instances of these 3d objects - World3dModelModelInstance.
 * Model instances are having keyframes - World3dModelModelInstanceKeyframe.
 * World3dModel may also have cameras. Each World3dModelCamera is having
 * keyframes - World3dModelCameraKeyframe.
 *
 * USAGE:
 * Don't forget to call SetPathFilename before Load/Save
 *
 * @author Matija Tomaskovic
 * @version 07-Aug-2001
 */

#if !defined(_World3dModel_H__INCLUDED_)
#define _World3dModel_H__INCLUDED_


#include <tomaskovic\util\Vector.h>
#include <tomaskovic\util\SuperString.h>
#include <tomaskovic\util\InputStream.h>
#include <tomaskovic\util\OutputStream.h>
#include <tomaskovic\xml\XMLElement.h>
#include "Object3dModel.h"
#include "World3d.h"

typedef struct {
    char szName[256];				// Model name
	char szFilename[512];			// Filename
	char szType[64];				// WAVEFRONT / AUTODESK3DS
    Object3dModel *pObject3dModel;	// Loaded later
} W3D_MODEL_DEFINITION;

typedef struct {
    int iFrameNo;
    char szName[256];
} W3D_FRAME_NAME;


class World3dModel
{
public:
    World3dModel();
    virtual ~World3dModel();

	//
	// Load / Store
	//

	void SetPathFilename(char* pszPathFilename);

	BOOL Load(InputStream* pInputStream);
	void Save(OutputStream* pOutputStream);

	//
	// Data
	//

    Vector vModelDefinitions;	// Vector of W3D_MODEL_DEFINITIONs
    Vector vFrameNames;
    Vector vFrameObjects;		// World3dModelCamera & World3dModelModelInstance

	Vector vAutodesk3dsDatabases;

	SuperString strPathFilename;

	//
	// Utility function
	//
public:
	W3D_MODEL_DEFINITION* GetModelDefinition(char* pszName);
	void PopulateWorld(int iFramePosition, World3d &world3d);
	int GetTotalFrames();
	void RemoveFrameObject(char* pszName);
	void RemoveModelDefinition(char* pszModelName);

	XMLElement* SaveModelDefinition(
		W3D_MODEL_DEFINITION *pModelDefinition,
		char* pszWorld3dModelPathFilename);
};

#endif // !defined(_World3dModel_H__INCLUDED_)
