/**
 * World3dModelCamera.cpp
 * Interface for the World3dModelCamera class.
 *
 * USAGE:
 * @author Matija Tomaskovic
 * @version 13-Jul-2001
 */

#if !defined(_World3dModelCamera_H__INCLUDED_)
#define _World3dModelCamera_H__INCLUDED_


#include <tomaskovic\util\Vector.h>
#include <tomaskovic\util\SuperString.h>
#include <tomaskovic\xml\XMLElement.h>
#include "World3dModelFrameObject.h"
#include "World3dModelCameraKeyframe.h"
#include "Camera.h"

class World3dModelCamera : public World3dModelFrameObject
{
public:
    World3dModelCamera();
    virtual ~World3dModelCamera();

	XMLElement* Save();
	BOOL Load(XMLElement* pECamera);

    BOOL ApplyToCamera(int iFrameNo, Camera* pCamera);
    void SaveCameraStateAsKeyframe(int iFrameNo, Camera* pCamera);

};

#endif // !defined(_World3dModelCamera_H__INCLUDED_)
