/**
 * World3dModelCameraKeyframe.cpp
 * Implementation of the World3dModelCameraKeyframe class.
 *
 * @author Matija Tomaskovic
 * @version 13-Jul-2001
 */

#include "World3dModelCameraKeyframe.h"

World3dModelCameraKeyframe::World3dModelCameraKeyframe() {
}


World3dModelCameraKeyframe::~World3dModelCameraKeyframe() {
}

XMLElement* World3dModelCameraKeyframe::Save() {
	XMLElement* pEKeyframe = new XMLElement("camera-keyframe");
	pEKeyframe->AddAttribute("frame-number", iFrameNo);
	pEKeyframe->AddAttribute("eye-x", fEyeX, 6);
	pEKeyframe->AddAttribute("eye-y", fEyeY, 6);
	pEKeyframe->AddAttribute("eye-z", fEyeZ, 6);
	pEKeyframe->AddAttribute("target-x", fTargetX, 6);
	pEKeyframe->AddAttribute("target-y", fTargetY, 6);
	pEKeyframe->AddAttribute("target-z", fTargetZ, 6);
	pEKeyframe->AddAttribute("up-x", fTargetX, 6);
	pEKeyframe->AddAttribute("up-y", fTargetY, 6);
	pEKeyframe->AddAttribute("up-z", fTargetZ, 6);
	pEKeyframe->AddAttribute("field-of-view", fFOV, 6);
	return pEKeyframe;
}

void World3dModelCameraKeyframe::ApplyToCamera(Camera *pCamera) {
	pCamera->fTargetX = fTargetX;
	pCamera->fTargetY = fTargetY;
	pCamera->fTargetZ = fTargetZ;
	pCamera->fEyeX = fEyeX;
	pCamera->fEyeY = fEyeY;
	pCamera->fEyeZ = fEyeZ;
	pCamera->fUpX = fUpX;
	pCamera->fUpY = fUpY;
	pCamera->fUpZ = fUpZ;
	pCamera->fFOV = fFOV;
}
