/**
 * World3dModelFrameObject.cpp
 * Implementation of the World3dModelFrameObject class.
 *
 * @author Matija Tomaskovic
 * @version 13-Jul-2001
 */

#include "World3dModelFrameObject.h"

World3dModelFrameObject::World3dModelFrameObject() {
	aFrames.SetElementSize(sizeof(int));
}


World3dModelFrameObject::~World3dModelFrameObject() {
	for (int i=0; i<vKeyframes.Size(); i++) {
		World3dModelKeyframe* pKeyframe = 
			(World3dModelKeyframe*) vKeyframes.ElementAt(i);
		delete pKeyframe;
	}
}



World3dModelKeyframe* World3dModelFrameObject::GetKeyframe(int iFrameNo) {
	for (int i=0; i<vKeyframes.Size(); i++) {
		World3dModelKeyframe* pKeyframe = 
			(World3dModelKeyframe*) vKeyframes.ElementAt(i);
		if (pKeyframe->iFrameNo == iFrameNo)
			return pKeyframe;
	}
	return NULL;
}



BOOL World3dModelFrameObject::HasFrame(int iFrameNo) {
	for (int i=0; i<aFrames.Size(); i++) {
		int* p = (int*) aFrames.ElementAt(i);
		if (*p == iFrameNo)
			return TRUE;
	}
	return FALSE;
}

BOOL World3dModelFrameObject::HasKeyframe(int iFrameNo) {
	for (int i=0; i<vKeyframes.Size(); i++) {
		World3dModelKeyframe* pKeyframe = 
			(World3dModelKeyframe*) vKeyframes.ElementAt(i);
		if (pKeyframe->iFrameNo == iFrameNo)
			return TRUE;
	}
	return FALSE;
}


void World3dModelFrameObject::RemoveFrame(int iFrameNo) {
	for (int i=0; i<aFrames.Size(); i++) {
		int* p = (int*) aFrames.ElementAt(i);
		if (*p == iFrameNo) {
			aFrames.DeleteElementAt(i);
			return;
		}
	}
}

void World3dModelFrameObject::RemoveKeyframe(int iFrameNo) {
	for (int i=0; i<vKeyframes.Size(); i++) {
		World3dModelKeyframe* pKeyframe = 
			(World3dModelKeyframe*) vKeyframes.ElementAt(i);
		vKeyframes.RemoveAt(i);
		delete pKeyframe;
		return;
	}
}

void World3dModelFrameObject::AddFrame(int iFrameNo) {
	int* pi = (int*) aFrames.AddElement();
	*pi = iFrameNo;
}

/**
 * @return frame number of last keyframe
 */
int World3dModelFrameObject::GetMaxKeyframeFrameNo()
{
	int iFrameNo;
	for (int i=0; i<vKeyframes.Size(); i++) {
		World3dModelKeyframe* pKeyframe = 
			(World3dModelKeyframe*) vKeyframes.ElementAt(i);
		if ((i == 0) || (pKeyframe->iFrameNo > iFrameNo))
			iFrameNo = pKeyframe->iFrameNo;
	}
	return iFrameNo;
}

World3dModelKeyframe* World3dModelFrameObject::GetKeyframeBefore(int iFramePosition) {
	World3dModelKeyframe *pKeyframeBefore = NULL;
	for (int i=iFramePosition-1; i>=0; i--) {
		if (HasKeyframe(i)) {
			return GetKeyframe(i);
		}
	}
	return NULL;
}

World3dModelKeyframe* World3dModelFrameObject::GetKeyframeAfter(int iFramePosition) {
	World3dModelKeyframe *pKeyframeBefore = NULL;
	for (int i=iFramePosition+1; i<=GetMaxKeyframeFrameNo(); i++) {
		if (HasKeyframe(i)) {
			return GetKeyframe(i);
		}
	}
	return NULL;
}
