/**
 * World3dModelFrameObject.cpp
 * Interface for the World3dModelFrameObject class.
 *
 * @author Matija Tomaskovic
 * @version 13-Jul-2001
 */

#if !defined(_World3dModelFrameObject_H__INCLUDED_)
#define _World3dModelFrameObject_H__INCLUDED_


#include <tomaskovic\util\Vector.h>
#include <tomaskovic\util\SuperString.h>
#include <tomaskovic\util\Array.h>
#include "World3dModelKeyframe.h"


class World3dModelFrameObject
{
public:
	World3dModelKeyframe* GetKeyframeAfter(int iFramePosition);
	World3dModelKeyframe* GetKeyframeBefore(int iFramePosition);
    World3dModelFrameObject();
    virtual ~World3dModelFrameObject();

	//
	// Data
	//

    SuperString strName;
	SuperString strType;	// Camera / ModelInstance
    Vector vKeyframes;	// objects based on World3dModelKeyfame
	Array aFrames;		// array of frame integer numbers


	//
	// Utility function
	//

	World3dModelKeyframe* GetKeyframe(int iFrameNo);
	void RemoveKeyframe(int iFrameNo);
	void RemoveFrame(int iFrameNo);

	BOOL HasFrame(int iFrameNo);
	BOOL HasKeyframe(int iFrameNo);

	int GetMaxKeyframeFrameNo();
	void AddFrame(int iFrameNo);

};

#endif // !defined(_World3dModelFrameObject_H__INCLUDED_)
