/**
 * World3dModelModelInstance.cpp
 * Implementation of the World3dModelModelInstance class.
 *
 * @author Matija Tomaskovic
 * @version 21-May-2001
 */

#include "World3dModelModelInstance.h"
#include "World3dModelModelInstanceKeyframe.h"
#include <tomaskovic\xml\XMLElement.h>
#include <tomaskovic\xml\XMLAttribute.h>


World3dModelModelInstance::World3dModelModelInstance() {
	strType.Set("ModelInstance");
}


World3dModelModelInstance::~World3dModelModelInstance() {
}


XMLElement* World3dModelModelInstance::Save() {
	XMLElement* pEModelInstance = new XMLElement("model-instance");
	pEModelInstance->AddAttribute("instance-name", strName.GetBuffer());
	pEModelInstance->AddAttribute("model-name", strModelName.GetBuffer());
	// Save keyframes
	for (int t=0; t<vKeyframes.Size(); t++) {
		World3dModelModelInstanceKeyframe* pModelInstanceKeyframe=
			(World3dModelModelInstanceKeyframe*) vKeyframes.ElementAt(t);
		XMLElement* pEKeyframe = pEModelInstance->AddChildElement("model-instance-keyframe");
		pEKeyframe->AddAttribute("frame", pModelInstanceKeyframe->iFrameNo);
		pEKeyframe->AddAttribute("pos-x", pModelInstanceKeyframe->fPosX, 6);
		pEKeyframe->AddAttribute("pos-y", pModelInstanceKeyframe->fPosY, 6);
		pEKeyframe->AddAttribute("pos-z", pModelInstanceKeyframe->fPosZ, 6);
	}
	// Save frames
	for (t=0; t<aFrames.Size(); t++) {
		int* p = (int*) aFrames.ElementAt(t);
		XMLElement* pEKeyframe = pEModelInstance->AddChildElement("model-instance-frame");
		pEKeyframe->AddAttribute("frame-number", *p);
	}
	return pEModelInstance;
}


BOOL World3dModelModelInstance::Load(XMLElement* pEModelInstance) {

	/*
        <model-instance instance-name="q1" model-name="quad.obj">
            <model-instance-keyframe frame="20" pos-x="0.0" pos-y="0.0" pos-z="1.0"/>
            <model-instance-keyframe frame="22" pos-x="0.0" pos-y="0.0" pos-z="1.0"/>
            <model-instance-keyframe frame="21" pos-x="0.0" pos-y="0.0" pos-z="1.0"/>
        </model-instance>
	*/

	char cbPath[256];
	SuperString strValue;

	pEModelInstance->GetValue(&strValue, "@instance-name");
	strName.Set(strValue.GetBuffer());

	pEModelInstance->GetValue(&strValue, "@model-name");
	strModelName.Set(strValue.GetBuffer());

	int iKeyframes = pEModelInstance->GetCount("model-instance-keyframe");
	for (int t=0; t<iKeyframes; t++) {
		World3dModelModelInstanceKeyframe* pModelInstanceKeyframe = 
			new World3dModelModelInstanceKeyframe();

		wsprintf(cbPath, "model-instance-keyframe<%d>@frame", t+1);
		pEModelInstance->GetValue(&strValue, cbPath);
		pModelInstanceKeyframe->iFrameNo = strValue.IntValue();

		wsprintf(cbPath, "model-instance-keyframe<%d>@pos-x", t+1);
		pEModelInstance->GetValue(&strValue, cbPath);
		pModelInstanceKeyframe->fPosX = strValue.FloatValue();

		wsprintf(cbPath, "model-instance-keyframe<%d>@pos-y", t+1);
		pEModelInstance->GetValue(&strValue, cbPath);
		pModelInstanceKeyframe->fPosY = strValue.FloatValue();

		wsprintf(cbPath, "model-instance-keyframe<%d>@pos-z", t+1);
		pEModelInstance->GetValue(&strValue, cbPath);
		pModelInstanceKeyframe->fPosZ = strValue.FloatValue();

		vKeyframes.AddElement(pModelInstanceKeyframe); 
	}

	int iFrames = pEModelInstance->GetCount("model-instance-frame");
	for (t=0; t<iFrames; t++) {
		int* p = (int*) aFrames.AddElement();
		wsprintf(cbPath, "model-instance-frame<%d>@frame-number", t+1);
		pEModelInstance->GetValue(&strValue, cbPath);
		*p = strValue.IntValue();
	}

	return TRUE;
}


void World3dModelModelInstance::ApplyToObject3d(
	int iFramePosition, Object3d &object3d) 
{
	if (HasFrame(iFramePosition)) {

		//
		// Calc interpolated keyframe for ModelInstance
		//

		World3dModelModelInstanceKeyframe keyframe;
		World3dModelModelInstanceKeyframe *pKeyframeBefore = 
			(World3dModelModelInstanceKeyframe*) GetKeyframeBefore(iFramePosition);
		World3dModelModelInstanceKeyframe *pKeyframeAfter = 
			(World3dModelModelInstanceKeyframe*) GetKeyframeAfter(iFramePosition);

		if ((!pKeyframeBefore) || (!pKeyframeAfter))
			// ERROR: this shouldn't happen - no keyframe before frame
			return;

		float fPos = iFramePosition;
		float fBefore = pKeyframeBefore->iFrameNo;
		float fAfter = pKeyframeAfter->iFrameNo;
		float fAmount = (fPos - fBefore) / (fAfter - fBefore);

		keyframe.fPosX = pKeyframeBefore->fPosX + 
			(pKeyframeAfter->fPosX - pKeyframeBefore->fPosX) * fAmount;
		keyframe.fPosY = pKeyframeBefore->fPosY + 
			(pKeyframeAfter->fPosY - pKeyframeBefore->fPosY) * fAmount;
		keyframe.fPosZ = pKeyframeBefore->fPosZ + 
			(pKeyframeAfter->fPosZ - pKeyframeBefore->fPosZ) * fAmount;

		keyframe.ApplyToObject3d(object3d);
		return;
	}
	else if (HasKeyframe(iFramePosition)) {
		World3dModelModelInstanceKeyframe *pKeyframe =
			(World3dModelModelInstanceKeyframe*) GetKeyframe(iFramePosition);
		pKeyframe->ApplyToObject3d(object3d);
		return;
	}

	return;
}
