/**
 * Array.cpp
 *
 * @author Matija Tomaskovic
 * @version 25-May-2001
 */

#include "Array.h"
#include "MemoryManager.h"


Array::Array() {
    iElements = 0;
    iElementSize = -1;
}


Array::~Array() {
    iElements = 0;
    iElementSize = 0;
}

void Array::SetElementSize(int iElementSize) {
	if (this->iElementSize == iElementSize)
		return;
    this->iElementSize = iElementSize;
    iElements = 0;
}

int Array::GetElementSize() {
    return iElementSize;
}

void* Array::ElementAt(int iIndex) {
	if (iElementSize == -1) {
		::MessageBox(NULL, "Array size not set", "ERROR", MB_OK);
		return NULL;
	}
    return buffer.GetBuffer() + (iIndex * iElementSize);
}

void* Array::AddElement() {
	if (iElementSize == -1) {
		::MessageBox(NULL, "Array size not set", "ERROR", MB_OK);
		return NULL;
	}
    EnsureSize(iElements + 1);
    iElements++;
    return ElementAt(iElements-1);
}

void Array::DeleteElementAt(int iIndex) {
    memcpy( buffer.GetBuffer() + iIndex*iElementSize, 
			buffer.GetBuffer() + (iIndex+1)*iElementSize,
            (iElements - iIndex - 1)*iElementSize);
}

void Array::EnsureSize(int iNewSize) {
	buffer.EnsureSize(iNewSize * iElementSize);
}

int Array::Size() {
    return iElements;
}


void* Array::GetBuffer() {
    return buffer.GetBuffer();
}
