/**
 * Array.h
 *
 * @author Matija Tomaskovic
 * @version 04-Jun-2001
 */

#if !defined(__Array_H__INCLUDED__)
#define __Array_H__INCLUDED__

#include <windows.h>
#include "Buffer.h"

class Array
{
public:

    Array();
    ~Array();

    int Size();
    void SetElementSize(int iElementSize);
    int GetElementSize();
    void* ElementAt(int iIndex);
    void* AddElement();
    void* GetBuffer();
    void DeleteElementAt(int iIndex);


private:

    int iElementSize;   // Memory size of single element
    int iElements;      // Number of elements
    BYTE* pElements;    // Buffer of elements

    int iMaxElements;   // Max. number of elements (allocated space in pElements)

    void EnsureSize(int iNewSize);

	Buffer buffer;

};

#endif // !defined(__Array_H__INCLUDED__)
