#include <tomaskovic\util\FileInputStream.h>
#include <tomaskovic\util\MemoryManager.h>
#include "BitmapRGB.h"

BitmapRGB::BitmapRGB() {
    iWidth = 0;
    iHeight = 0;
    pBits = NULL;
}

BitmapRGB::~BitmapRGB() {
    if (pBits) {
        MemFree(pBits);
    }
}


BOOL BitmapRGB::Load(char *pszBMPPathFilename) {

    FileInputStream fis;
    if (fis.Open(pszBMPPathFilename)) {
        BITMAPFILEHEADER  bfh;
        if (!fis.ReadBytes((BYTE*) &bfh, sizeof(BITMAPFILEHEADER)))
            return FALSE;

        BITMAPINFOHEADER  bih;
        if (!fis.ReadBytes((BYTE*) &bih, sizeof(BITMAPINFOHEADER)))
            return FALSE;

        iWidth = bih.biWidth;
        iHeight = bih.biHeight;

		iBytesPerLine = iWidth * 3;
        if ((iBytesPerLine % 4) != 0)
            iBytesPerLine += 4 - (iBytesPerLine % 4);

        if (bih.biBitCount != 24)
            return FALSE;

        pBits = (BYTE*) MemAlloc(iBytesPerLine * iHeight);
        if (!fis.ReadBytes((BYTE*) pBits, iBytesPerLine * iHeight))
            return FALSE;

        fis.Close();
    }
	return TRUE;
}

