/**
 * Buffer.cpp
 *
 * @author Matija Tomaskovic
 * @version 20-Jun-2001
 */

#include "Buffer.h"
#include "MemoryManager.h"


Buffer::Buffer() {
    iBufferTotalSize = 100;
    pBuffer = (BYTE*) MemAlloc(iBufferTotalSize);
    iBufferSize = 0;
}


Buffer::~Buffer() {
    if (pBuffer) {
        delete pBuffer;
        pBuffer = NULL;
    }
}

void Buffer::Append(BYTE* pBuffer, int iSize) {
    EnsureSize(iBufferSize + iSize);
    memcpy(this->pBuffer + iBufferSize, pBuffer, iSize);
	iBufferSize += iSize;
}

void Buffer::AppendByte(BYTE b) {
    EnsureSize(iBufferSize + 1);
	pBuffer[iBufferSize] = b;
	iBufferSize++;
}


void Buffer::EnsureSize(int iNewSize) {
    if (iNewSize < iBufferTotalSize)
        return;
    while (iNewSize >= iBufferTotalSize)
        iBufferTotalSize *= 2;
    pBuffer = (BYTE*) MemRealloc(pBuffer, iBufferTotalSize);
}


int Buffer::GetSize() {
    return iBufferSize;
}

BYTE Buffer::ByteAt(int iPosition) {
    return pBuffer[iPosition];
}

void Buffer::LeftRemove(int iBytes) {
    memcpy(pBuffer, pBuffer + iBytes, iBufferSize - iBytes);
    iBufferSize -= iBytes;
}

BYTE* Buffer::GetBuffer() {
	return pBuffer;
}

void Buffer::AppendString(char *pszText) {
	Append((BYTE*) pszText, strlen(pszText));
}

void Buffer::Append(Buffer *pBufferSrc) {
	Append(pBufferSrc->GetBuffer(), pBufferSrc->GetSize());
}

void Buffer::SetSize(int iNewSize)
{
	EnsureSize(iNewSize);
	iBufferSize = iNewSize;
}
