/**
 * BufferInputStream.cpp: implementation of the BufferInputStream class.
 *
 * @author Matija Tomaskovic
 * @version 13-Jun-2001
 */

#include <windows.h>
#include "BufferInputStream.h"
#include "MemoryManager.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

BufferInputStream::BufferInputStream(Buffer* pBuffer) {
	this->pBuffer = pBuffer;
	iBufferPosition = 0;
}


BufferInputStream::~BufferInputStream() {
}


int BufferInputStream::ReadImpl() {
	if (iBufferPosition >= pBuffer->GetSize())
		return -1;

    if (tempBuffer.GetSize() > 0) {
        BYTE b = tempBuffer.ByteAt(0);
        tempBuffer.LeftRemove(1);
        return b;
    }


	BYTE* p = pBuffer->GetBuffer();
	return p[iBufferPosition++];
}

void BufferInputStream::PushBack(int iChar) {
    tempBuffer.AppendByte((BYTE) iChar);
}

void BufferInputStream::PushBack(BYTE* pBuffer, int iSize) {
    tempBuffer.Append(pBuffer, iSize);
}

