/**
 * BufferInputStream.h
 * Interface for the BufferInputStream class.
 *
 * @author Matija Tomaskovic
 * @version 13-Jun-2001
 */

#if !defined(_BufferInputStream_H__INCLUDED_)
#define _BufferInputStream_H__INCLUDED_


#include "stdio.h"
#include "Buffer.h"
#include "InputStream.h"
#include <windows.h>


class BufferInputStream : public InputStream
{
public:

	BufferInputStream(Buffer *pBuffer);
	virtual ~BufferInputStream();

	/**
	 * @return -1 if no more data or byte otherwise
	 */
	int ReadImpl();

    void PushBack(int iChar);
    void PushBack(BYTE* pBuffer, int iSize);

private:
	Buffer* pBuffer;
	int iBufferPosition;	// Current position in buffer

    Buffer tempBuffer;
};

#endif // !defined(_BufferInputSTREAM_H__INCLUDED_)
