// Configuration.cpp: implementation of the Configuration class.
//
//////////////////////////////////////////////////////////////////////

#include "stdio.h"
#include "Configuration.h"
#include "TextLines.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

Configuration::Configuration()
{
}

Configuration::~Configuration()
{
	int i;
	for (i=0; i<vVariables.Size(); i++) {
		SuperString* p = (SuperString*) vVariables.ElementAt(i);
		delete p;
	}
	for (i=0; i<vValues.Size(); i++) {
		SuperString* p = (SuperString*) vValues.ElementAt(i);
		delete p;
	}
}


BOOL Configuration::LoadFromFile(char *pszFilename)
{
	TextLines tl;
	if (tl.LoadFromFile(pszFilename)) {

		for (int iRow = 0; iRow < tl.GetLineCount(); iRow++) {
		
			SuperString* pString = tl.GetLine(iRow);

			// Trim it...
			pString->TrimLeft();
			pString->TrimRight();

			// Empty line?
			if (pString->GetLength() == 0) {
				AddPair("", "");
				continue;
			}

			// Comment?
			if (pString->CharAt(0) == '#') {
				AddPair(pString->GetBuffer(), "");
				continue;
			}

			int iIndex = pString->IndexOf('=');

			// If no '=' or no variable name
			if ((iIndex == -1) || (iIndex==0)) {
				// TODO: Should report error here...
				SuperString s;
				s.Append("#ERROR# ");
				s.Append(pString);
				continue;
			}

			SuperString SSVariable;
			pString->Substring(&SSVariable, 0, iIndex);

			SuperString SSValue;
			pString->Substring(&SSValue, iIndex+1, pString->GetLength()-iIndex-1);

			AddPair(SSVariable.GetBuffer(), SSValue.GetBuffer());
		}

		return TRUE;
	}

	return FALSE;
}


char* Configuration::FindValue(char *pszVariable)
{
	for (int i=0; i<vVariables.Size(); i++) {
		SuperString* p = (SuperString*) vVariables.ElementAt(i);
		if (p->Equals(pszVariable)) {
			SuperString *pp = (SuperString*) vValues.ElementAt(i);
			return pp->GetBuffer();
		}
	}

	return NULL;
}

char* Configuration::GetValueAndSave(char *pszVariable, char *pszDefaultValue)
{
	char* pszValue = FindValue(pszVariable);
	if (pszValue == NULL) {
		AddPair(pszVariable, pszDefaultValue);
		return pszDefaultValue;
	}
	else {
		return pszValue;
	}
}

void Configuration::GetValueAndSave(char *pszVariable, char *pszDefaultValue, SuperString* pDestForValue)
{
	char* pszValue = GetValueAndSave(pszVariable, pszDefaultValue);
	pDestForValue->Set(pszValue);
}

int Configuration::GetIntValueAndSave(char *pszVariable, int iDefaultValue)
{
	char cb[100];
	wsprintf(cb, "%d", iDefaultValue);
	SuperString s;
	s.Set(GetValueAndSave(pszVariable, cb));
	return s.IntValue();
}


void Configuration::AddPair(char *pszVariable, char *pszValue)
{
	SuperString *pSSVariable = new SuperString(pszVariable);
	SuperString *pSSValue = new SuperString(pszValue);
	vVariables.AddElement(pSSVariable);
	vValues.AddElement(pSSValue);
}

BOOL Configuration::SaveToFile(char *pszFilename)
{
	FILE *pFile = fopen(pszFilename, "wb");
	if (!pFile)
		return FALSE;

	for (int i=0; i<vVariables.Size(); i++) {
		SuperString *pSSVariable = (SuperString*) vVariables.ElementAt(i);
		SuperString *pSSValue = (SuperString*) vValues.ElementAt(i);

		// Empty line?
		if (pSSVariable->GetLength() == 0) {
			fwrite("\r\n", 1, 2, pFile);
		}
		// Comment?
		else if (pSSVariable->CharAt(0) == '#') {
			fwrite(pSSVariable->GetBuffer(), 1, pSSVariable->GetLength(), pFile);
			fwrite("\r\n", 1, 2, pFile);
		}
		// Value pair
		else {
			fwrite(pSSVariable->GetBuffer(), 1, pSSVariable->GetLength(), pFile);
			fwrite("=", 1, 1, pFile);
			fwrite(pSSValue->GetBuffer(), 1, pSSValue->GetLength(), pFile);
			fwrite("\r\n", 1, 2, pFile);
		}
	}

	fclose(pFile);
	return TRUE;
}

void Configuration::SetValue(char *pszVariable, char *pszValue)
{
	// Try to find value
	for (int i=0; i<vVariables.Size(); i++) {
		SuperString* p = (SuperString*) vVariables.ElementAt(i);
		if (p->Equals(pszVariable)) {
			SuperString *pValue = (SuperString*) vValues.ElementAt(i);
			pValue->Set(pszValue);
			return;
		}
	}

	// Can't find it - add it to end
	AddPair(pszVariable, pszValue);
}
