// Configuration.h: interface for the Configuration class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_CONFIGURATION_H__A1499AB6_4C39_11D5_951D_0080C8E5FEE4__INCLUDED_)
#define AFX_CONFIGURATION_H__A1499AB6_4C39_11D5_951D_0080C8E5FEE4__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include <tomaskovic\util\SuperString.h>
#include "Vector.h"

class Configuration
{
public:
	void SetValue(char* pszVariable, char* pszValue);
	Configuration();
	virtual ~Configuration();

	BOOL SaveToFile(char* pszFilename);
	void AddPair(char* pszVariable, char* pszValue);
	char* GetValueAndSave(char* pszVariable, char* pszDefaultValue);
	int GetIntValueAndSave(char *pszVariable, int iDefaultValue);
	void GetValueAndSave(char *pszVariable, char *pszDefaultValue, SuperString* pDestForValue);
	char* FindValue(char* pszVariable);

	BOOL LoadFromFile(char* pszFilename);

	/**
	 * Variable and value pairs...
	 * Comments are written here also having variable="#comment" and value=""
	 * Empty lines are written here also having variable="" and value=""
	 */
	Vector vVariables;
	Vector vValues;

};

#endif // !defined(AFX_CONFIGURATION_H__A1499AB6_4C39_11D5_951D_0080C8E5FEE4__INCLUDED_)
