/**
 * FileInputStream.cpp: implementation of the FileInputStream class.
 *
 * @author Matija Tomaskovic
 * @version 13-Jun-2001
 */

#include <windows.h>
#include "FileInputStream.h"
#include "MemoryManager.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

FileInputStream::FileInputStream()
{
	iBufferSize = 32000;
	pBuffer = (BYTE*) MemAlloc(iBufferSize);
	iBufferBytes = 0;
	iBufferPosition = 0;
	pFile = NULL;
}


FileInputStream::~FileInputStream()
{
	Close();
	if (pBuffer) {
		MemFree(pBuffer);
		pBuffer = NULL;
		iBufferSize = 0;
		iBufferPosition = 0;
	}
}

BOOL FileInputStream::Open(char *pszFilename)
{
	pFile = fopen(pszFilename, "rb");
	if (!pFile) {
		return FALSE;
	}

	return TRUE;
}



void FileInputStream::Close()
{
	if (pFile) {
		fclose(pFile);
        pFile = NULL;
	}
}

int FileInputStream::ReadImpl()
{
	if (!pFile)
		return -1;

	// if no data in buffer, or we are at end of buffer
	if ((iBufferBytes <= 0) ||
		(iBufferPosition >= iBufferBytes))
	{
		// Read new chunk
		iBufferBytes = fread(pBuffer, 1, iBufferSize, pFile);
		if (iBufferBytes <= 0) {
			iBufferBytes = 0;
			return -1;
		}

		iBufferPosition = 0;
	}

	return pBuffer[iBufferPosition++];
}


