/**
 * FileInputStream.h
 * Interface for the FileInputStream class.
 *
 * @author Matija Tomaskovic
 * @version 13-Jun-2001
 */

#if !defined(__FileInputStream_H__INCLUDED__)
#define __FileInputStream_H__INCLUDED__


#include "stdio.h"
#include "Buffer.h"
#include "InputStream.h"
#include <windows.h>

class FileInputStream : public InputStream
{
public:

	FileInputStream();
	virtual ~FileInputStream();

    /**
     * @return FALSE if can't open file
     */
	BOOL Open(char* pszFilename);

    /**
     * Closes file
     */
	void Close();

	/**
	 * @return -1 if no more data or byte otherwise
	 */
	int ReadImpl();


private:
	FILE* pFile;
	BYTE* pBuffer;
	int iBufferSize;		// Total size of buffer
	int iBufferBytes;		// Actual size of data in buffer
	int iBufferPosition;	// Current position in buffer

};

#endif // !defined(__FILEINPUTSTREAM_H__INCLUDED__)
