/**
 * FileOutputStream.cpp: implementation of the FileOutputStream class.
 *
 * @author Matija Tomaskovic
 * @version 13-Jun-2001
 */

#include <windows.h>
#include "FileOutputStream.h"
#include "MemoryManager.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

FileOutputStream::FileOutputStream() {
}


FileOutputStream::~FileOutputStream() {
	Close();
}

BOOL FileOutputStream::Open(char *pszFilename)
{
    pFile = fopen(pszFilename, "ab");
	if (!pFile) {
		return FALSE;
	}

	return TRUE;
}



void FileOutputStream::Close() {
	if (pFile) {
		fclose(pFile);
        pFile = NULL;
	}
}

void FileOutputStream::Write(BYTE* pBuffer, int iSize) {
    fwrite(pBuffer, iSize, 1, pFile);
}

void FileOutputStream::WriteImpl(BYTE b) {
    fwrite(&b, 1, 1, pFile);
}
