/**
 * FileOutputStream.h
 * Interface for the FileOutputStream class.
 *
 * @author Matija Tomaskovic
 * @version 20-Jun-2001
 */

#if !defined(_FileOutputStream_H__INCLUDED_)
#define _FileOutputStream_H__INCLUDED_


#include "stdio.h"
#include "Buffer.h"
#include "OutputStream.h"
#include <windows.h>

class FileOutputStream : public OutputStream
{
public:

    FileOutputStream();
    virtual ~FileOutputStream();

    /**
     * @return FALSE if can't open file
     */
	BOOL Open(char* pszFilename);

    /**
     * Closes file
     */
	void Close();

    void Write(BYTE* pBuffer, int iSize);
	void WriteImpl(BYTE b);

private:
	FILE* pFile;

};

#endif // !defined(_FILEINPUTSTREAM_H__INCLUDED_)
