/**
 * InputStream.cpp
 * Implementation of the InputStream class.
 *
 * @author Matija Tomaskovic
 * @version 05-Jul-2001
 */


#include "InputStream.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

InputStream::InputStream() {
}


InputStream::~InputStream() {
}

int InputStream::Read()
{
    if (tempBuffer.GetSize() > 0) {
        BYTE b = tempBuffer.ByteAt(0);
        tempBuffer.LeftRemove(1);
        return b;
    }

	return ReadImpl();
}

void InputStream::PushBack(int iChar) {
    tempBuffer.AppendByte((BYTE) iChar);
}

void InputStream::PushBack(BYTE* pBuffer, int iSize) {
    tempBuffer.Append(pBuffer, iSize);
}

/**
 * @return number of bytes read
 */
int InputStream::ReadBytes(BYTE *pBuffer, int iBytes) {
	int i = 0;
	while (i<iBytes) {
		int b = Read();
		if (b == -1)
			break; 
		pBuffer[i++] = (BYTE) b;
	}
	return i;
}


BOOL InputStream::IsEndOfStream() {
	int b = Read();
	if (b == -1)
		return TRUE;
	PushBack(b);
	return FALSE;
}
