/**
 * InputStream.h
 * Interface for the InputStream class.
 *
 * @author Matija Tomaskovic
 * @version 05-Jul-2001
 */

#if !defined(_InputStream_H__INCLUDED_)
#define _InputStream_H__INCLUDED_


#include "stdio.h"
#include "Buffer.h"
#include <windows.h>

class InputStream
{
public:

	InputStream();
	virtual ~InputStream();

	/**
	 * @return -1 if no more data or byte otherwise
	 */
	int Read();

	virtual int ReadImpl() = 0;


	// Push back functionality
public:
	BOOL IsEndOfStream();
	int ReadBytes(BYTE* pBuffer, int iBytes);
    void PushBack(int iChar);
    void PushBack(BYTE* pBuffer, int iSize);
private:
    Buffer tempBuffer;

};

#endif // !defined(_InputStream_H__INCLUDED_)
