/**
 * MemoryManager.cpp
 *
 * @author Matija Tomaskovic
 * @version 13-Jun-2001
 */

#include "MemoryManager.h"
#include "malloc.h"
#include "memory.h"

void* MemAlloc(int iSize) {
	return malloc(iSize);
}

void MemFree(void* pMem) {
	free(pMem);
}

void* MemRealloc(void* pOldMem, int iNewSize) {
	void *pNewMem = malloc(iNewSize);
	int iOldMemSize = _msize(pOldMem);
    if (iOldMemSize < iNewSize)
        memcpy(pNewMem, pOldMem, iOldMemSize);
    else
        memcpy(pNewMem, pOldMem, iNewSize);
	free(pOldMem);
	return pNewMem;
	//return realloc(pOldMem, iNewSize);
}

// Combinations

void MemFreePtr(void** ppMem) {
	MemFree(*ppMem);
	ppMem = 0;
}

char* MemAllocC(int iSize) {
	return (char*) MemAlloc(iSize);
}

char* MemReallocC(char* pOldMem, int iNewSize) {
	return (char*) MemRealloc(pOldMem, iNewSize);
}

