/****************************************************************************
 * SuperFilename.cpp
 *
 * @author Matija Tomaskovic
 * @version 04-Jun-2001
 ***************************************************************************/

#include "SuperFilename.h"


SuperFilename::SuperFilename() {
}

SuperFilename::~SuperFilename() {
}

void SuperFilename::SetPathFilename(char* pszPathFilename) {
    SuperString s(pszPathFilename);
    int i=s.LastIndexOf('\\');
    if (i == -1) {
        strPath.Set("");
        strPathFilename.Set(pszPathFilename);
        strFilename.Set(pszPathFilename);
    }
    else {
        s.Substring(&strFilename, i+1, s.GetLength()-i);
        s.Substring(&strPath, 0, i);
        strPathFilename.Set(pszPathFilename);
    }
}

void SuperFilename::SetPath(char* pszPath) {
    strPath.Set(pszPath);
    strPathFilename.Set(pszPath);
    strPathFilename.Append("\\");
    strPathFilename.Append(&strFilename);
}

void SuperFilename::MergeRelativeFilename(char* pszFilename) {
    SuperString s(pszFilename);
    if (s.GetLength() >= 2) {
        if ((s.CharAt(0) == '.') && (s.CharAt(1) == '\\')) {
            // e.g. ".\players\player1.mtl"
            s.Substring(2, s.GetLength() - 2);
            SuperString ss;
            ss.Set(strPath.GetBuffer());
            ss.Append("\\");
            ss.Append(&s);
            SetPathFilename(ss.GetBuffer());
            return;
        }
    }
    if (s.GetLength() > 0) {
        if (s.CharAt(0) == '\\') {
            SuperString ss;
            ss.Set(strPath.GetBuffer());
            ss.Append(&s);
            SetPathFilename(ss.GetBuffer());
            return;
        }
        else {
            SuperString ss;
            ss.Set(strPath.GetBuffer());
            ss.Append("\\");
            ss.Append(&s);
            SetPathFilename(ss.GetBuffer());
            return;
        }
    }

}

void SuperFilename::SetFilename(char *pszFilename) {
	strFilename.Set(pszFilename);
    strPathFilename.Set(strPath.GetBuffer());
    strPathFilename.Append("\\");
    strPathFilename.Append(pszFilename);
}

void SuperFilename::GetRelativeFilename(
	char *pszRelativeFilenameDestination, 
	char *pszBasePathFilename, 
	char *pszTargetPathFilename)
{
	// e.g. c:\game\bin        [game.exe]
	// e.g. c:\game\bin\space  [earth.w3m]
	// return:        .\space  [earth.w3m]

	// c:\game\bin\mod
	// c:\game\gfx\space
	//         ..\..\\


	int i=0;

	SuperFilename sfBase;
	sfBase.SetPathFilename(pszBasePathFilename);

	SuperFilename sfTarget;
	sfTarget.SetPathFilename(pszTargetPathFilename);

	SuperString strBasePath(sfBase.strPath.GetBuffer());
	SuperString strTargetPath(sfTarget.strPath.GetBuffer());

	SuperString strDest;

	// Are drives different?
	if (pszBasePathFilename[0] != pszTargetPathFilename[0]) {
		strcpy(pszRelativeFilenameDestination, sfTarget.strPathFilename.GetBuffer());
		return;
	}
	else {

		// Same drives - skip them and check directories
		strBasePath.Substring(3, strBasePath.GetLength()-3);
		strTargetPath.Substring(3, strTargetPath.GetLength()-3);

		// Skip all directories that are same
		int iSlashBase;
		int iSlashTarget;
		while(TRUE) {
			iSlashBase = strBasePath.IndexOf('\\');
			iSlashTarget = strTargetPath.IndexOf('\\');
			if ((iSlashBase != iSlashTarget) || 
				(iSlashBase == -1) ||
				(iSlashTarget == -1)) 
			{
				break;
			}
			SuperString sA(strBasePath.GetBuffer());
			SuperString sT(strTargetPath.GetBuffer());
			sA.Substring(0, iSlashBase);
			sT.Substring(0, iSlashBase);
			if (!sA.Equals(sT.GetBuffer()))
				break;
			strBasePath.Substring(iSlashBase+1, strBasePath.GetLength()-iSlashBase-1);
			strTargetPath.Substring(iSlashTarget+1, strTargetPath.GetLength()-iSlashTarget-1);
		}

		// Last directories in both cases?
		if ((iSlashBase == -1) && (iSlashTarget == -1)) {
			// are they same?
			if (strBasePath.Equals(strTargetPath.GetBuffer())) {
				// result: ".\\filename.ext"
				strDest.Append(".");
			}
			else {
				// result is "..\\target\\filename.ext
				strDest.Append("..\\");
				strDest.Append(strTargetPath.GetBuffer());
			}
		}
		// Last directory of target?
		else if ((iSlashBase != -1) && (iSlashTarget == -1)) {

			// Base:        dir1\\dirX+
			// target:	   dir4

			// Check if dir1 == dir4 to skip dir1 and dir4
			SuperString sA(strBasePath.GetBuffer());
			sA.Substring(0, iSlashBase);
			if ((iSlashBase == strTargetPath.GetLength()) &&
				(strTargetPath.Equals(sA.GetBuffer())) ) 
			{
				// skip dir1 and dir4
				strBasePath.Substring(iSlashBase+1, 
					strBasePath.GetLength()-iSlashBase-1);
				strTargetPath.Substring(iSlashBase+1, 
					strTargetPath.GetLength()-iSlashBase-1);
			}

			// Add "..\\" for every dir in Base
			strDest.Append("..");
			while(TRUE) {
				int t = strBasePath.IndexOf('\\');
				if (t == -1)
					break;
				strDest.Append("\\..");
				strBasePath.Substring(t+1, strBasePath.GetLength()-t-1);
			}

			// append part from target (if it was not truncated before)
			strDest.Append(strTargetPath.GetBuffer());
		}
		// Last directory of Base?
		else if ((iSlashBase == -1) && (iSlashTarget != -1)) {

			// Base:        dir1
			// target:	   dir2\\dirX+

			// Check if dir1 == dir2 to skip dir2
			SuperString sT(strTargetPath.GetBuffer());
			sT.Substring(0, iSlashTarget);
			if ((iSlashTarget == strBasePath.GetLength()) &&
				(strBasePath.Equals(sT.GetBuffer())) ) 
			{
				// skip dir2
				strTargetPath.Substring(iSlashTarget+1, 
					strTargetPath.GetLength()-iSlashTarget-1);
				strDest.Append(".\\");
			}
			else {
				strDest.Append("..\\");
			}

			// add every dir from target
			strDest.Append(&strTargetPath);
		}
		// no last directory in both,.. but they are different...
		else if ((iSlashBase != -1) && (iSlashTarget != -1)) {
			// Base:        dir1\\dirX+
			// target:	   dir2\\dirX+

			// Add "..\\" for every dir in Base
			while(TRUE) {
				strDest.Append("..\\");
				int t = strBasePath.IndexOf('\\');
				if (t == -1)
					break;
				strBasePath.Substring(t+1, strBasePath.GetLength()-t-1);
			}

			// add every dir from target
			strDest.Append(&strTargetPath);
		}
	}

	strDest.Append("\\");
	strDest.Append(sfTarget.strFilename.GetBuffer());
	strcpy(pszRelativeFilenameDestination, strDest.GetBuffer());

}

void SuperFilename::GetAbsoluteFilename(
	char* pszAbsoluteFilenameDestination, 
	char* pszBasePathFilename, 
	char* pszRelativePathFilename)
{
	// base:	 c:\\games\\dune\\demo.exe
	// relative: ..\\gfx\\\image.gif
	//			 .\\image.gif

	SuperFilename sfBase;
	sfBase.SetPathFilename(pszBasePathFilename);

	SuperFilename sfRel;
	sfRel.SetPathFilename(pszRelativePathFilename);

	SuperString strRel(pszRelativePathFilename);

	SuperString strDest;
	strDest.Append(&sfBase.strPath);

	// If case:   .\\dirX\\filename.ext
    if (strRel.GetLength() >= 2) {
        if ((strRel.CharAt(0) == '.') && (strRel.CharAt(1) == '\\')) {
			// remove ".\\" and append rest on base path
            strRel.Substring(2, strRel.GetLength() - 2);
			strDest.Append("\\");
			strDest.Append(&strRel);
			strcpy(pszAbsoluteFilenameDestination, strDest.GetBuffer());
            return;
        }
    }

	// remove paths while we have "..\\" in relative...
	while ( (strRel.GetLength() >= 3) &&
			(strRel.CharAt(0) == '.') &&
			(strRel.CharAt(1) == '.') &&
			(strRel.CharAt(2) == '\\'))
	{
		int i = strDest.LastIndexOf('\\');
		if (i == -1) {
			// Error case - no more paths to remove
		}
		else {
			strDest.Substring(0, i);
			strRel.Substring(3, strRel.GetLength() - 3);
		}
	}

	strDest.Append("\\");
	strDest.Append(&strRel);

	strcpy(pszAbsoluteFilenameDestination, strDest.GetBuffer());
}
