/****************************************************************************
 * SuperFilename.h:
 * Interface for the SuperFilename class.
 *
 * @author Matija Tomaskovic
 * @version 04-Jun-2001
 ***************************************************************************/

#if !defined(_SUPER_FILE_H_INCLUDED_)
#define _SUPER_FILENAME_H_INCLUDED_

#include "windows.h"
#include "SuperString.h"


class SuperFilename
{
public:
	void SetFilename(char* pszFilename);

    SuperFilename();
    virtual ~SuperFilename();

    SuperString strFilename;
    SuperString strPath;
    SuperString strPathFilename;

    void SetPathFilename(char* pszPathFilename);
    void SetPath(char* pszPath);
    void MergeRelativeFilename(char* pszFilename);

	void GetRelativeFilename(
		char *pszRelativeFilenameDestination, 
		char *pszBasePathFilename, 
		char *pszTargetPathFilename);

	void GetAbsoluteFilename(
		char* pszAbsoluteFilenameDestination, 
		char* pszBasePathFilename, 
		char* pszRelativePathFilename);

private:

};


#endif // !defined(_SUPER_FILENAME_H_INCLUDED_)
