/****************************************************************************
 * Log.h: interface for the SuperLog class.
 *
 * @author Matija Tomaskovic
 * @version 30/Aug/2000
 ***************************************************************************/

#if !defined(_SUPER_LOG__INCLUDED_)
#define _SUPER_LOG__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include <stdio.h>
#include <windows.h>
#include <stdlib.h>

class SuperLog
{
public:
	SuperLog(char *pszName, char *pszPathFilename, bool bDebugOnly);
	virtual ~SuperLog();

	static void PrepareLog(char* pszName, char* pszPathFilename);
	static void PrepareLog(char* pszName, char* pszPathFilename, bool bDebugOnly);
	static void ClearLogList();

	/**
	 * Final log function that all functions call
	 */
	void logLn(char* pszText);

	static void logLn(char* pszLogName, char* pszText);
	static void logLn(char* pszLogName, char* pszFormat, BYTE* pData, int iDataLength);
	static void logLnWithIntInt(char* pszLogName, char* pszFormat, int iVal1, int iVal2);
	static void logLnWithString(char* pszLogName, char* pszFormat, char* pszValue);
	static void logLnWithInt(char* pszLogName, char* pszFormat, int iValue);
	static void logLnWithBlockString(char* pszLogName, char *pszFormat, char* pszText, unsigned long ulStrLen);
	static void logLnWithHexBlock(char *pszLogName, char *pszFormat, BYTE *pData, int iDataLength);

	//
	// Data
	//

	char m_szPathFilename[_MAX_PATH];
	char m_szName[500];
	bool m_bDebugOnly;	// if true, only debug versions with _DEBUG defined will output log data..
};

#endif // !defined(_SUPER_LOG__INCLUDED_)
