/****************************************************************************
 * SuperString.cpp
 *
 * @author Matija Tomaskovic
 * @version 20-May-2001
 ***************************************************************************/

#include "SuperString.h"
#include "MemoryManager.h"


//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

SuperString::SuperString() {
	iDataSize = 500;
	pData = (char*) MemAlloc(iDataSize);
	pData[0] = 0;
	iLength = 0;
}

SuperString::SuperString(char* pszText) {
	iLength = strlen(pszText);
	iDataSize = iLength+1;
	pData = (char*) MemAlloc(iDataSize);
	strcpy(pData, pszText);
	pData[iLength] = 0;
}

SuperString::~SuperString() {
	MemFreePtr((void**)&pData);
	iDataSize = 0;
	iLength = 0;
}

void SuperString::Append(char c) {
	EnsureSize(iLength+1);
	pData[iLength] = c;
	pData[iLength+1] = 0;
	iLength++;
}

void SuperString::EnsureSize(int iNewSize)
{
	iNewSize++; // because of end '\0'

	if (iNewSize <= iDataSize)
		return;

	while(iNewSize > iDataSize) {
		iDataSize = iDataSize*2;
	}

	pData = MemReallocC(pData, iDataSize+1);
}

int SuperString::GetLength() {
	return iLength;
}

void SuperString::TrimLeft() {
	while((iLength > 0) && (pData[0] == ' ')) {
		memcpy(pData, pData+1, iLength+1);
		iLength--;
	}
}

void SuperString::TrimRight() {
	while((iLength > 0) && (pData[iLength-1] == ' ')) {
		pData[iLength-1] = 0;
		iLength--;
	}
}

char SuperString::CharAt(int iPosition) {
	return pData[iPosition];
}

int SuperString::IndexOf(char c) {
	for (int i=0; i<iLength; i++) {
		if (pData[i] == c)
			return i;
	}

	return -1;
}

void SuperString::Substring(SuperString* pDestination, int iStart, int iLength) {
	pDestination->Clear();
	for (int i=iStart; i<iStart+iLength; i++) {
		pDestination->Append(CharAt(i));
	}
}

void SuperString::Substring(int iStart, int iLength) {
    SuperString s;
	for (int i=iStart; i<iStart+iLength; i++) {
        s.Append(CharAt(i));
	}
    Set(&s);
}

char* SuperString::GetBuffer() {
	return pData;
}

BOOL SuperString::Equals(char *pszText) {
	if (pszText == NULL)
		return FALSE;

	if (strlen(pszText) != iLength)
		return FALSE;

	if (strcmp(pszText, pData) == 0)
		return TRUE;
	else
		return FALSE;
}

void SuperString::Append(char *pszText) {
	int len = strlen(pszText);
	EnsureSize(iLength + len);
	strcat(pData, pszText);
	iLength += len;
}

void SuperString::Append(SuperString *pText) {
	Append(pText->GetBuffer());
}

int SuperString::IntValue() {
	int iValue;
	int iFields = sscanf(pData, "%d", &iValue);
	if (iFields != 1)
		return -1;
	else
		return iValue;
}

float SuperString::FloatValue() {
    float fValue;
    int iFields = sscanf(pData, "%f", &fValue);
	if (iFields != 1)
        return 0;
	else
        return fValue;
}

void SuperString::Set(char *pszValue) {
	iLength = 0;
	pData[0] = 0;
	Append(pszValue);
}

void SuperString::Set(SuperString *pSource) {
	Set(pSource->GetBuffer());
}


int SuperString::LastIndexOf(char c) {
    for (int i=iLength-1; i>=0; i--) {
        if (CharAt(i) == c)
            return i;
    }
    return -1;
}


void SuperString::Clear() {
	iLength = 0;
	pData[0] = 0;
}



void SuperString::AppendFloat(float fValue, int iDecimals) {

	char cb[50];
	int iWholePart = (int) fValue;
	wsprintf(cb, "%d", iWholePart);
	Append(cb);

	Append('.');

	float fFracPart = fValue - ((float) iWholePart);
	float fPadded = FALSE;
	int iMultiply = 1;
	while(iDecimals) {
		iMultiply *= 10;
		iDecimals--;
	}
	fFracPart *= iMultiply;

	int iFracPart = (int) fFracPart;
	wsprintf(cb, "%d", iFracPart);
	Append(cb);
}

void SuperString::AppendInt(int iValue) {
	char cb[50];
	wsprintf(cb, "%d", iValue);
	Append(cb);
}
