/****************************************************************************
 * SuperString.h: interface for the SuperString class.
 *
 * @author Matija Tomaskovic
 * @version 20-May-2001
 ***************************************************************************/

#if !defined(__SuperString_H_INCLUDED__)
#define __SuperString_H_INCLUDED__

#include <vector>
#include "windows.h"

class SuperString
{
public:
	void AppendInt(int iValue);
	void AppendFloat(float fValue, int iDecimals);
    SuperString();
    SuperString(char* pszText);
    virtual ~SuperString();

	void Set(SuperString *pSource);
	void Set(char* pszValue);
	int IntValue();
    float FloatValue();
	void Append(SuperString* pText);
	void Append(char* pszText);
	BOOL Equals(char* pszText);
	char* GetBuffer();
    void Substring(int iStart, int iLength);
	void Substring(SuperString* pDestination, int iStart, int iLength);
	void Clear();
	int IndexOf(char c);
    int LastIndexOf(char c);
	char CharAt(int iPosition);
	void TrimRight();
	void TrimLeft();
	int GetLength();
	void EnsureSize(int iNewSize);
	void Append(char c);

private:

	char* pData;
	int iDataSize;	// Total size of pData buffer
	int iLength;	// Actual length of text

};

using namespace std;
typedef vector<SuperString*> StringVector;


#endif // !defined(__SuperString_H_INCLUDED__)


